/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.genericsystem.api.defaults.DefaultRoot;
import org.genericsystem.cache.Cache;
import org.genericsystem.cache.DefaultEngine;
import org.genericsystem.cache.Generic;
import org.genericsystem.cache.Transaction;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.Archiver;
import org.genericsystem.kernel.Config;
import org.genericsystem.kernel.GarbageCollector;
import org.genericsystem.kernel.Root;
import org.genericsystem.kernel.Statics;
import org.genericsystem.kernel.SystemCache;

public class Engine
extends Generic
implements DefaultEngine<Generic> {
    private final Root.TsGenerator generator = new Root.TsGenerator();
    private final ThreadLocal<Cache<Generic>> cacheLocal = new ThreadLocal();
    private final SystemCache<Generic> systemCache;
    private final GarbageCollector<Generic> garbageCollector = new GarbageCollector((DefaultRoot)this);
    private final Archiver<Generic> archiver;
    private boolean initialized = false;

    public Engine(Class<?> ... userClasses) {
        this((Serializable)((Object)"Engine"), userClasses);
    }

    public Engine(Serializable engineValue, Class<?> ... userClasses) {
        this(engineValue, (String)null, userClasses);
    }

    public Engine(Serializable engineValue, String persistentDirectoryPath, Class<?> ... userClasses) {
        super.init(0L, null, Collections.emptyList(), engineValue, Collections.emptyList(), Statics.SYSTEM_TS);
        Cache<Generic> cache = this.start(this.newCache());
        this.systemCache = new SystemCache((DefaultRoot)this, Root.class);
        this.systemCache.mount(Arrays.asList(Config.MetaAttribute.class, Config.MetaRelation.class, Config.SystemMap.class), (Class[])userClasses);
        cache.flush();
        this.archiver = new Archiver((DefaultRoot)this, persistentDirectoryPath);
        cache.pickNewTs();
        this.initialized = true;
    }

    public Cache<Generic> newCache(Cache.ContextEventListener<Generic> listener) {
        return new Cache<Generic>(new Transaction(this.getRoot()), listener);
    }

    public Transaction<Generic> buildTransaction() {
        return new Transaction<Generic>(this);
    }

    public Generic getMetaAttribute() {
        return this.find(Config.MetaAttribute.class);
    }

    public Generic getMetaRelation() {
        return this.find(Config.MetaRelation.class);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public Cache<Generic> start(Cache<Generic> cacheManager) {
        if (!this.equals(cacheManager.getRoot())) {
            throw new IllegalStateException();
        }
        this.cacheLocal.set(cacheManager);
        return cacheManager;
    }

    @Override
    public void stop(Cache<Generic> cacheManager) {
        assert (this.cacheLocal.get() == cacheManager);
        this.cacheLocal.set(null);
    }

    @Override
    public Cache<Generic> getCurrentCache() {
        Cache<Generic> currentCache = this.cacheLocal.get();
        if (currentCache == null) {
            throw new IllegalStateException("Unable to find the current cache. Did you miss to call start() method on it ?");
        }
        return currentCache;
    }

    public <Custom extends Generic> Custom find(Class<?> clazz) {
        return (Custom)((Generic)this.systemCache.get(clazz));
    }

    public Class<?> findAnnotedClass(Generic generic) {
        return this.systemCache.getByVertex((AbstractVertex)generic);
    }

    public void close() {
        this.archiver.close();
    }

    public long pickNewTs() {
        return this.generator.pickNewTs();
    }

    @Override
    public GarbageCollector<Generic> getGarbageCollector() {
        return this.garbageCollector;
    }

    public Generic getMap() {
        return this.find(Config.SystemMap.class);
    }
}

