/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.util.stream.Stream;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.exception.ConcurrencyControlException;
import org.genericsystem.api.exception.OptimisticLockConstraintViolationException;
import org.genericsystem.api.exception.RollbackException;
import org.genericsystem.cache.AbstractCacheElement;
import org.genericsystem.cache.AbstractGeneric;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.Checker;
import org.genericsystem.kernel.DependenciesImpl;

public class CacheElement<T extends AbstractGeneric<T>>
extends AbstractCacheElement<T> {
    private final AbstractCacheElement<T> subCache;
    private final DependenciesImpl<T> adds = new DependenciesImpl();
    private final DependenciesImpl<T> removes = new DependenciesImpl();

    public CacheElement(AbstractCacheElement<T> subCache) {
        this.subCache = subCache;
    }

    public AbstractCacheElement<T> getSubCache() {
        return this.subCache;
    }

    public int getCacheLevel() {
        return this.subCache instanceof CacheElement ? ((CacheElement)this.subCache).getCacheLevel() + 1 : 0;
    }

    @Override
    boolean isAlive(T generic) {
        return this.adds.contains(generic) || !this.removes.contains(generic) && this.subCache.isAlive(generic);
    }

    void checkConstraints(Checker<T> checker) throws RollbackException {
        this.adds.forEach(x -> checker.checkAfterBuild(true, true, (AbstractVertex)x));
        this.removes.forEach(x -> checker.checkAfterBuild(false, true, (AbstractVertex)x));
    }

    protected T plug(T generic) {
        this.adds.add(generic);
        return generic;
    }

    protected void unplug(T generic) {
        if (!this.adds.remove(generic)) {
            this.removes.add(generic);
        }
    }

    @Override
    Snapshot<T> getInstances(T generic) {
        return new Snapshot<T>((AbstractGeneric)generic){
            final /* synthetic */ AbstractGeneric val$generic;
            {
                this.val$generic = abstractGeneric;
            }

            public T get(Object o) {
                AbstractGeneric result = (AbstractGeneric)CacheElement.this.adds.get(o);
                return result != null ? result : (!CacheElement.this.removes.contains(o) ? (AbstractGeneric)CacheElement.this.subCache.getInstances(this.val$generic).get(o) : result);
            }

            public Stream<T> get() {
                return Stream.concat(CacheElement.this.subCache.getInstances(this.val$generic).get().filter(x -> !CacheElement.this.removes.contains(x)), CacheElement.this.adds.get().filter(x -> !x.isMeta() && ((AbstractGeneric)x.getMeta()).equals(this.val$generic)));
            }
        };
    }

    @Override
    Snapshot<T> getInheritings(T generic) {
        return new Snapshot<T>((AbstractGeneric)generic){
            final /* synthetic */ AbstractGeneric val$generic;
            {
                this.val$generic = abstractGeneric;
            }

            public T get(Object o) {
                AbstractGeneric result = (AbstractGeneric)CacheElement.this.adds.get(o);
                return result != null ? result : (!CacheElement.this.removes.contains(o) ? (AbstractGeneric)CacheElement.this.subCache.getInheritings(this.val$generic).get(o) : result);
            }

            public Stream<T> get() {
                return Stream.concat(CacheElement.this.subCache.getInheritings(this.val$generic).get().filter(x -> !CacheElement.this.removes.contains(x)), CacheElement.this.adds.get().filter(x -> x.getSupers().contains(this.val$generic)));
            }
        };
    }

    @Override
    Snapshot<T> getComposites(T generic) {
        return new Snapshot<T>((AbstractGeneric)generic){
            final /* synthetic */ AbstractGeneric val$generic;
            {
                this.val$generic = abstractGeneric;
            }

            public T get(Object o) {
                AbstractGeneric result = (AbstractGeneric)CacheElement.this.adds.get(o);
                return result != null ? result : (!CacheElement.this.removes.contains(o) ? (AbstractGeneric)CacheElement.this.subCache.getComposites(this.val$generic).get(o) : result);
            }

            public Stream<T> get() {
                return Stream.concat(CacheElement.this.subCache.getComposites(this.val$generic).get().filter(x -> !CacheElement.this.removes.contains(x)), CacheElement.this.adds.get().filter(x -> x.getComponents().contains(this.val$generic)));
            }
        };
    }

    void apply() throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        this.getSubCache().apply((Iterable<T>)this.removes, (Iterable<T>)this.adds);
    }

    @Override
    protected void apply(Iterable<T> removes, Iterable<T> adds) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        for (AbstractGeneric generic : removes) {
            this.unplug(generic);
        }
        for (AbstractGeneric generic : adds) {
            this.plug(generic);
        }
    }
}

