/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.util.HashSet;
import java.util.Set;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.defaults.DefaultRoot;
import org.genericsystem.api.exception.CacheNoStartedException;
import org.genericsystem.api.exception.ConcurrencyControlException;
import org.genericsystem.api.exception.OptimisticLockConstraintViolationException;
import org.genericsystem.api.exception.RollbackException;
import org.genericsystem.cache.AbstractCacheElement;
import org.genericsystem.cache.AbstractGeneric;
import org.genericsystem.cache.CacheElement;
import org.genericsystem.cache.DefaultEngine;
import org.genericsystem.cache.Generic;
import org.genericsystem.cache.Transaction;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.Builder;
import org.genericsystem.kernel.Context;
import org.genericsystem.kernel.LifeManager;

public class Cache<T extends AbstractGeneric<T>>
extends Context<T> {
    protected Transaction<T> transaction;
    protected CacheElement<T> cacheElement;
    private final ContextEventListener<T> listener;

    protected Cache(DefaultEngine<T> engine) {
        this(new Transaction<T>(engine));
    }

    protected Cache(Transaction<T> subContext) {
        this(subContext, new ContextEventListener<T>(){});
    }

    protected Cache(Transaction<T> subContext, ContextEventListener<T> listener) {
        super(subContext.getRoot());
        this.listener = listener;
        this.transaction = subContext;
        this.initialize();
    }

    public long getTs() {
        return this.transaction.getTs();
    }

    public Snapshot<T> getInstances(T generic) {
        return this.cacheElement.getInstances(generic);
    }

    public Snapshot<T> getInheritings(T generic) {
        return this.cacheElement.getInheritings(generic);
    }

    public Snapshot<T> getComposites(T generic) {
        return this.cacheElement.getComposites(generic);
    }

    protected void initialize() {
        this.cacheElement = new CacheElement(this.cacheElement == null ? new TransactionElement() : this.cacheElement.getSubCache());
    }

    public void pickNewTs() throws RollbackException {
        this.transaction = new Transaction(this.getRoot(), this.getRoot().pickNewTs());
        this.listener.triggersRefreshEvent();
    }

    public void flush() {
        if (!((Object)((Object)this)).equals((Object)this.getRoot().getCurrentCache())) {
            this.discardWithException((Throwable)new CacheNoStartedException("The Cache isn't started"));
        }
        try {
            this.internalFlush();
        }
        catch (ConcurrencyControlException | OptimisticLockConstraintViolationException exception) {
            this.discardWithException(exception);
        }
    }

    private void internalFlush() throws OptimisticLockConstraintViolationException, ConcurrencyControlException {
        this.checkConstraints();
        this.doSynchronizedApplyInSubContext();
        this.initialize();
        this.listener.triggersFlushEvent();
    }

    public void flushLater() {
        if (!((Object)((Object)this)).equals((Object)this.getRoot().getCurrentCache())) {
            this.discardWithException((Throwable)new CacheNoStartedException("The Cache isn't started"));
        }
        ConcurrencyControlException cause = null;
        for (int attempt = 0; attempt < 50; ++attempt) {
            try {
                this.internalFlush();
                return;
            }
            catch (ConcurrencyControlException e) {
                cause = e;
                try {
                    Thread.sleep(15L);
                    this.pickNewTs();
                    continue;
                }
                catch (InterruptedException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            catch (Exception e) {
                this.discardWithException(e);
            }
        }
        this.discardWithException(cause);
    }

    protected void doSynchronizedApplyInSubContext() throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        CacheElement<T> originalCacheElement = this.cacheElement;
        if (this.cacheElement.getSubCache() instanceof CacheElement) {
            this.cacheElement = (CacheElement)this.cacheElement.getSubCache();
        }
        try {
            this.synchronizedApply(originalCacheElement);
        }
        finally {
            this.cacheElement = originalCacheElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizedApply(CacheElement<T> cacheElement) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
        DefaultRoot defaultRoot = this.getRoot();
        synchronized (defaultRoot) {
            cacheElement.apply();
        }
    }

    public void clear() {
        this.initialize();
        this.listener.triggersClearEvent();
        this.listener.triggersRefreshEvent();
    }

    public void mount() {
        this.cacheElement = new CacheElement<T>(this.cacheElement);
    }

    public void unmount() {
        AbstractCacheElement<T> subCache = this.cacheElement.getSubCache();
        this.cacheElement = subCache instanceof CacheElement ? (CacheElement)subCache : new CacheElement<T>(subCache);
        this.listener.triggersClearEvent();
        this.listener.triggersRefreshEvent();
    }

    public DefaultEngine<T> getRoot() {
        return (DefaultEngine)super.getRoot();
    }

    public Cache<T> start() {
        return this.getRoot().start(this);
    }

    public void stop() {
        this.getRoot().stop(this);
    }

    protected void triggersMutation(T oldDependency, T newDependency) {
        if (this.listener != null) {
            this.listener.triggersMutationEvent(oldDependency, newDependency);
        }
    }

    protected Builder<T> buildBuilder() {
        return new Builder<T>(this){

            protected Class<T> getTClass() {
                return Generic.class;
            }

            protected Class<T> getSystemTClass() {
                return Generic.SystemClass.class;
            }
        };
    }

    protected T plug(T generic) {
        this.cacheElement.plug(generic);
        this.getChecker().checkAfterBuild(true, false, generic);
        return generic;
    }

    protected void unplug(T generic) {
        this.getChecker().checkAfterBuild(false, false, generic);
        this.cacheElement.unplug(generic);
    }

    protected void checkConstraints() throws RollbackException {
        this.cacheElement.checkConstraints(this.getChecker());
    }

    public void discardWithException(Throwable exception) throws RollbackException {
        this.clear();
        throw new RollbackException(exception);
    }

    public int getCacheLevel() {
        return this.cacheElement.getCacheLevel();
    }

    public static interface ContextEventListener<X> {
        default public void triggersMutationEvent(X oldDependency, X newDependency) {
        }

        default public void triggersRefreshEvent() {
        }

        default public void triggersClearEvent() {
        }

        default public void triggersFlushEvent() {
        }
    }

    protected class TransactionElement
    extends AbstractCacheElement<T> {
        private Set<LifeManager> lockedLifeManagers = new HashSet<LifeManager>();

        protected TransactionElement() {
        }

        private void writeLockAllAndCheckMvcc(Iterable<T> adds, Iterable<T> removes) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
            for (AbstractGeneric remove : removes) {
                this.writeLockAndCheckMvcc(remove);
            }
            for (AbstractGeneric add : adds) {
                this.writeLockAndCheckMvcc((AbstractGeneric)add.getMeta());
                for (AbstractGeneric superT : add.getSupers()) {
                    this.writeLockAndCheckMvcc(superT);
                }
                for (AbstractGeneric component : add.getComponents()) {
                    if (component == null) continue;
                    this.writeLockAndCheckMvcc(component);
                }
                this.writeLockAndCheckMvcc(add);
            }
        }

        private void writeLockAndCheckMvcc(T generic) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
            LifeManager manager;
            if (generic != null && !this.lockedLifeManagers.contains(manager = generic.getLifeManager())) {
                manager.writeLock();
                this.lockedLifeManagers.add(manager);
                manager.checkMvcc(Cache.this.getTs());
            }
        }

        private void writeUnlockAll() {
            for (LifeManager lifeManager : this.lockedLifeManagers) {
                lifeManager.writeUnlock();
            }
            this.lockedLifeManagers = new HashSet<LifeManager>();
        }

        @Override
        protected void apply(Iterable<T> removes, Iterable<T> adds) throws ConcurrencyControlException, OptimisticLockConstraintViolationException {
            try {
                this.writeLockAllAndCheckMvcc(adds, removes);
                Cache.this.transaction.apply(removes, adds);
            }
            finally {
                this.writeUnlockAll();
            }
        }

        @Override
        boolean isAlive(T generic) {
            return Cache.this.transaction.isAlive((AbstractVertex)generic);
        }

        @Override
        Snapshot<T> getInheritings(T generic) {
            return Cache.this.transaction.getInheritings((AbstractVertex)generic);
        }

        @Override
        Snapshot<T> getInstances(T generic) {
            return Cache.this.transaction.getInstances((AbstractVertex)generic);
        }

        @Override
        Snapshot<T> getComposites(T generic) {
            return Cache.this.transaction.getComposites((AbstractVertex)generic);
        }
    }
}

