/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.genericsystem.api.exception.RollbackException;
import org.genericsystem.cache.Cache;
import org.genericsystem.cache.Generic;
import org.genericsystem.cache.GenericsCache;
import org.genericsystem.cache.IEngine;
import org.genericsystem.cache.Root;
import org.genericsystem.cache.Vertex;
import org.genericsystem.impl.AbstractGeneric;
import org.genericsystem.impl.SystemCache;
import org.genericsystem.kernel.AbstractVertex;

public class Engine
extends Generic
implements IEngine<Generic, Engine, Vertex, Root> {
    private final ThreadLocal<Cache<Generic, Engine, Vertex, Root>> cacheLocal = new ThreadLocal();
    private final SystemCache<Generic> systemCache = new SystemCache((AbstractGeneric)this);
    private final Root root;
    private final GenericsCache<Generic> genericsCache = new GenericsCache();

    public Engine(Class<?> ... userClasses) {
        this((Serializable)((Object)"Engine"), userClasses);
    }

    public Engine(Serializable engineValue, Class<?> ... userClasses) {
        this.init(false, null, Collections.emptyList(), engineValue, Collections.emptyList());
        this.root = this.buildRoot(engineValue);
        Cache cache = this.newCache().start();
        Generic metaAttribute = (Generic)this.setInstance((AbstractVertex)this, this.getValue(), this.coerceToTArray(new Object[]{this}));
        ((Generic)this.setInstance((Serializable)((Object)AbstractVertex.SystemMap.class), this.coerceToTArray(new Object[]{this}))).enablePropertyConstraint();
        metaAttribute.disableReferentialIntegrity(0);
        for (Class<?> clazz : userClasses) {
            this.systemCache.set(clazz);
        }
        cache.flushAndUnmount();
    }

    @Override
    public Generic getOrBuildT(Class<?> clazz, boolean throwExistException, Generic meta, List<Generic> supers, Serializable value, List<Generic> components) {
        return (Generic)this.genericsCache.getOrBuildT(clazz, throwExistException, meta, supers, value, components);
    }

    public Root buildRoot(Serializable value) {
        return new Root(this, value);
    }

    @Override
    public Root unwrap() {
        return this.root;
    }

    @Override
    public Cache<Generic, Engine, Vertex, Root> start(Cache<Generic, Engine, Vertex, Root> cache) {
        if (!this.equals(cache.getEngine())) {
            throw new IllegalStateException();
        }
        this.cacheLocal.set(cache);
        return cache;
    }

    @Override
    public void stop(Cache<Generic, Engine, Vertex, Root> cache) {
        assert (this.cacheLocal.get() == cache);
        this.cacheLocal.set(null);
    }

    @Override
    public Cache<Generic, Engine, Vertex, Root> getCurrentCache() {
        Cache<Generic, Engine, Vertex, Root> currentCache = this.cacheLocal.get();
        if (currentCache == null) {
            throw new IllegalStateException();
        }
        return currentCache;
    }

    public <subT extends Generic> subT find(Class<subT> clazz) {
        return (subT)((Generic)this.systemCache.get(clazz));
    }

    public Engine getRoot() {
        return this;
    }

    public Engine getAlive() {
        return this;
    }

    public boolean isRoot() {
        return true;
    }

    @Override
    public void discardWithException(Throwable exception) throws RollbackException {
        IEngine.super.discardWithException(exception);
    }
}

