/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.genericsystem.kernel.Dependencies;

public class CacheDependencies<T>
implements Dependencies<T> {
    private final Set<T> inserts = new LinkedHashSet<T>();
    private final Set<T> deletes = new LinkedHashSet<T>();
    private final Supplier<Stream<T>> streamSupplier;

    public CacheDependencies(Supplier<Stream<T>> streamSupplier) {
        this.streamSupplier = streamSupplier;
    }

    public void add(T generic) {
        this.inserts.add(generic);
    }

    public boolean remove(T generic) {
        if (!this.inserts.remove(generic)) {
            return this.deletes.add(generic);
        }
        return true;
    }

    public Iterator<T> iterator() {
        return Stream.concat(this.streamSupplier.get().filter(x -> !this.deletes.contains(x)), this.inserts.stream()).iterator();
    }

    public String toString() {
        return this.stream().collect(Collectors.toList()).toString();
    }
}

