/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.exception.AliveConstraintViolationException;
import org.genericsystem.api.exception.ConstraintViolationException;
import org.genericsystem.api.exception.NotFoundException;
import org.genericsystem.api.exception.RollbackException;
import org.genericsystem.cache.AbstractContext;
import org.genericsystem.cache.AbstractGeneric;
import org.genericsystem.cache.CacheDependencies;
import org.genericsystem.cache.IEngine;
import org.genericsystem.cache.IRoot;
import org.genericsystem.cache.Transaction;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.Dependencies;
import org.genericsystem.kernel.Statics;
import org.genericsystem.kernel.systemproperty.constraints.Constraint;

public class Cache<T extends AbstractGeneric<T, U, V, W>, U extends IEngine<T, U, V, W>, V extends AbstractVertex<V, W>, W extends IRoot<V, W>>
extends AbstractContext<T, U, V, W> {
    protected AbstractContext<T, U, V, W> subContext;
    private transient Map<T, Dependencies<T>> inheritingsDependenciesMap;
    private transient Map<T, Dependencies<T>> instancesDependenciesMap;
    private transient Map<T, Map<T, Dependencies<T>>> metaComponentsDependenciesMap;
    private transient Map<T, Map<T, Dependencies<T>>> superComponentsDependenciesMap;
    protected Set<T> adds = new LinkedHashSet<T>();
    protected Set<T> removes = new LinkedHashSet<T>();

    public void clear() {
        this.inheritingsDependenciesMap = new HashMap<T, Dependencies<T>>();
        this.instancesDependenciesMap = new HashMap<T, Dependencies<T>>();
        this.metaComponentsDependenciesMap = new HashMap<T, Map<T, Dependencies<T>>>();
        this.superComponentsDependenciesMap = new HashMap<T, Map<T, Dependencies<T>>>();
        this.adds = new LinkedHashSet<T>();
        this.removes = new LinkedHashSet<T>();
    }

    protected Cache(U engine) {
        this(new Transaction(engine));
    }

    protected Cache(AbstractContext<T, U, V, W> subContext) {
        this.subContext = subContext;
        this.clear();
    }

    @Override
    public boolean isAlive(T generic) {
        return this.adds.contains(generic) || !this.removes.contains(generic) && this.getSubContext().isAlive(generic);
    }

    public Cache<T, U, V, W> mountNewCache() {
        return this.getEngine().buildCache(this).start();
    }

    public Cache<T, U, V, W> flushAndUnmount() {
        this.flush();
        return this.subContext instanceof Cache ? ((Cache)this.subContext).start() : this;
    }

    public Cache<T, U, V, W> clearAndUnmount() {
        this.clear();
        return this.subContext instanceof Cache ? ((Cache)this.subContext).start() : this;
    }

    public Cache<T, U, V, W> start() {
        return this.getEngine().start(this);
    }

    public void stop() {
        this.getEngine().stop(this);
    }

    public void flush() throws RollbackException {
        this.checkConstraints();
        try {
            this.getSubContext().apply(this.adds, this.removes);
        }
        catch (ConstraintViolationException e) {
            this.getEngine().discardWithException(e);
        }
        this.clear();
    }

    protected void checkConstraints() throws RollbackException {
        Object engine = this.getEngine();
        this.adds.forEach(x -> engine.check(Constraint.CheckingType.CHECK_ON_ADD, true, (AbstractVertex)x));
        this.removes.forEach(x -> engine.check(Constraint.CheckingType.CHECK_ON_REMOVE, true, (AbstractVertex)x));
    }

    protected void rollbackWithException(Throwable exception) throws RollbackException {
        this.clear();
        throw new RollbackException(exception);
    }

    @Override
    protected void apply(Iterable<T> adds, Iterable<T> removes) {
        removes.forEach(this::unplug);
        adds.forEach(this::plug);
    }

    @Override
    protected void simpleAdd(T generic) {
        if (!this.removes.remove(generic)) {
            this.adds.add(generic);
        }
    }

    @Override
    protected boolean simpleRemove(T generic) {
        if (!this.isAlive(generic)) {
            this.getEngine().discardWithException((Throwable)new AliveConstraintViolationException(generic + " is not alive"));
        }
        if (!this.adds.remove(generic)) {
            return this.removes.add(generic);
        }
        return true;
    }

    @Override
    public U getEngine() {
        return this.subContext.getEngine();
    }

    protected AbstractContext<T, U, V, W> getSubContext() {
        return this.subContext;
    }

    private Snapshot<T> getDependencies(Map<T, Dependencies<T>> multiMap, Supplier<Iterator<T>> subIteratorSupplier, T generic) {
        return () -> {
            Dependencies dependencies = (Dependencies)multiMap.get(generic);
            return dependencies == null ? (Iterator)subIteratorSupplier.get() : dependencies.iterator();
        };
    }

    @Override
    Snapshot<T> getInstances(T generic) {
        return this.getDependencies(this.instancesDependenciesMap, () -> this.subContext.getInstances((AbstractGeneric)generic).iterator(), generic);
    }

    @Override
    Snapshot<T> getInheritings(T generic) {
        return this.getDependencies(this.inheritingsDependenciesMap, () -> this.subContext.getInheritings((AbstractGeneric)generic).iterator(), generic);
    }

    private T index(Map<T, Dependencies<T>> multiMap, Supplier<Stream<T>> subStreamSupplier, T generic, T dependency) {
        Dependencies<T> dependencies = multiMap.get(generic);
        if (dependencies == null) {
            dependencies = new CacheDependencies<T>(subStreamSupplier);
            multiMap.put(generic, dependencies);
        }
        return (T)((AbstractGeneric)dependencies.set(dependency));
    }

    private boolean unIndex(Map<T, Dependencies<T>> multiMap, Supplier<Stream<T>> subStreamSupplier, T generic, T dependency) {
        Dependencies<T> dependencies = multiMap.get(generic);
        if (dependencies == null) {
            dependencies = new CacheDependencies<T>(subStreamSupplier);
            multiMap.put(generic, dependencies);
        }
        return dependencies.remove(dependency);
    }

    private T indexInstance(T generic, T instance) {
        return this.index(this.instancesDependenciesMap, () -> this.subContext.getInstances((AbstractGeneric)generic).stream(), generic, instance);
    }

    private T indexInheriting(T generic, T inheriting) {
        return this.index(this.inheritingsDependenciesMap, () -> this.subContext.getInheritings((AbstractGeneric)generic).stream(), generic, inheriting);
    }

    private boolean unIndexInstance(T generic, T instance) {
        return this.unIndex(this.instancesDependenciesMap, () -> this.subContext.getInstances((AbstractGeneric)generic).stream(), generic, instance);
    }

    private boolean unIndexInheriting(T generic, T inheriting) {
        return this.unIndex(this.inheritingsDependenciesMap, () -> this.subContext.getInheritings((AbstractGeneric)generic).stream(), generic, inheriting);
    }

    Snapshot<T> getComponents(T generic) {
        return () -> {
            Map<T, Dependencies<T>> dependencies = this.metaComponentsDependenciesMap.get(generic);
            return dependencies == null ? Collections.emptyIterator() : Statics.concat(this.metaComponentsDependenciesMap.get(generic).entrySet().stream(), x -> ((Dependencies)x.getValue()).stream()).iterator();
        };
    }

    @Override
    Snapshot<T> getMetaComponents(T generic, T meta) {
        return Cache.getIndex(this.metaComponentsDependenciesMap, () -> this.subContext.getMetaComponents((AbstractGeneric)generic, (AbstractGeneric)meta).stream(), generic, meta);
    }

    @Override
    Snapshot<T> getSuperComponents(T generic, T superT) {
        return Cache.getIndex(this.superComponentsDependenciesMap, () -> this.subContext.getSuperComponents((AbstractGeneric)generic, (AbstractGeneric)superT).stream(), generic, superT);
    }

    private T indexByMeta(T generic, T meta, T composite) {
        return (T)((AbstractGeneric)Cache.index(this.metaComponentsDependenciesMap, () -> this.subContext.getMetaComponents((AbstractGeneric)generic, (AbstractGeneric)meta).stream(), generic, meta, composite));
    }

    private T indexBySuper(T generic, T superT, T composite) {
        return (T)((AbstractGeneric)Cache.index(this.superComponentsDependenciesMap, () -> this.subContext.getSuperComponents((AbstractGeneric)generic, (AbstractGeneric)superT).stream(), generic, superT, composite));
    }

    private boolean unIndexByMeta(T generic, T meta, T composite) {
        return Cache.unIndex(this.metaComponentsDependenciesMap, () -> this.subContext.getMetaComponents((AbstractGeneric)generic, (AbstractGeneric)meta).stream(), generic, meta, composite);
    }

    private boolean unIndexBySuper(T generic, T superT, T composite) {
        return Cache.unIndex(this.superComponentsDependenciesMap, () -> this.subContext.getSuperComponents((AbstractGeneric)generic, (AbstractGeneric)superT).stream(), generic, superT, composite);
    }

    private static <T> Snapshot<T> getIndex(Map<T, Map<T, Dependencies<T>>> multiMap, Supplier<Stream<T>> subStreamSupplier, T generic, T index) {
        return () -> {
            Map dependencies = (Map)multiMap.get(generic);
            if (dependencies == null) {
                return ((Stream)subStreamSupplier.get()).iterator();
            }
            Dependencies dependenciesByIndex = (Dependencies)dependencies.get(index);
            if (dependenciesByIndex == null) {
                return ((Stream)subStreamSupplier.get()).iterator();
            }
            return dependenciesByIndex.iterator();
        };
    }

    private static <T> T index(Map<T, Map<T, Dependencies<T>>> multiMap, Supplier<Stream<T>> subStreamSupplier, T generic, T index, T composite) {
        Dependencies<T> dependenciesByIndex;
        Map<T, Dependencies<T>> dependencies = multiMap.get(generic);
        if (dependencies == null) {
            dependencies = new HashMap<T, Dependencies<T>>();
            multiMap.put(generic, dependencies);
        }
        if ((dependenciesByIndex = dependencies.get(index)) == null) {
            dependenciesByIndex = new CacheDependencies<T>(subStreamSupplier);
            dependencies.put(index, dependenciesByIndex);
        }
        return (T)dependenciesByIndex.set(composite);
    }

    private static <T> boolean unIndex(Map<T, Map<T, Dependencies<T>>> multiMap, Supplier<Stream<T>> subStreamSupplier, T generic, T index, T composite) {
        Dependencies<T> dependenciesByIndex;
        Map<T, Dependencies<T>> dependencies = multiMap.get(generic);
        if (dependencies == null) {
            dependencies = new HashMap<T, Dependencies<T>>();
            multiMap.put(generic, dependencies);
        }
        if ((dependenciesByIndex = dependencies.get(index)) == null) {
            dependenciesByIndex = new CacheDependencies<T>(subStreamSupplier);
            dependencies.put(index, dependenciesByIndex);
        }
        return dependenciesByIndex.remove(composite);
    }

    T plug(T generic) {
        AbstractGeneric result = this.indexInstance((AbstractGeneric)generic.getMeta(), generic);
        assert (result == generic);
        generic.getSupers().forEach(superGeneric -> this.indexInheriting(superGeneric, generic));
        generic.getComposites().stream().filter(composite -> !generic.equals(composite)).forEach(composite -> this.indexByMeta(composite, (AbstractGeneric)generic.getMeta(), generic));
        generic.getSupers().forEach(superGeneric -> generic.getComposites().stream().filter(composite -> !generic.equals(composite)).forEach(composite -> this.indexBySuper(composite, superGeneric, generic)));
        this.simpleAdd(generic);
        return (T)result;
    }

    boolean unplug(T generic) {
        boolean result = this.unIndexInstance((AbstractGeneric)generic.getMeta(), generic);
        if (!result) {
            this.getEngine().discardWithException((Throwable)new NotFoundException(generic.info()));
        }
        generic.getSupers().forEach(superGeneric -> this.unIndexInheriting(superGeneric, generic));
        generic.getComposites().stream().filter(composite -> !generic.equals(composite)).forEach(composite -> this.unIndexByMeta(composite, (AbstractGeneric)generic.getMeta(), generic));
        generic.getSupers().forEach(superGeneric -> generic.getComposites().stream().filter(composite -> !generic.equals(composite)).forEach(composite -> this.unIndexBySuper(composite, superGeneric, generic)));
        return result && this.simpleRemove(generic);
    }

    @Override
    V unwrap(T generic) {
        return this.getSubContext().unwrap(generic);
    }

    @Override
    T wrap(V vertex) {
        return this.getSubContext().wrap(vertex);
    }
}

