/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.exception.ConcurrencyControlException;
import org.genericsystem.api.exception.ConstraintViolationException;
import org.genericsystem.cache.AbstractGeneric;
import org.genericsystem.cache.IEngine;
import org.genericsystem.cache.IRoot;
import org.genericsystem.kernel.AbstractVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContext<T extends AbstractGeneric<T, U, V, W>, U extends IEngine<T, U, V, W>, V extends AbstractVertex<V, W>, W extends IRoot<V, W>> {
    static Logger log = LoggerFactory.getLogger(AbstractContext.class);

    public abstract U getEngine();

    public abstract boolean isAlive(T var1);

    protected void apply(Iterable<T> adds, Iterable<T> removes) throws ConcurrencyControlException, ConstraintViolationException {
        removes.forEach(this::simpleRemove);
        adds.forEach(this::simpleAdd);
    }

    protected abstract void simpleAdd(T var1);

    protected abstract boolean simpleRemove(T var1);

    abstract Snapshot<T> getInheritings(T var1);

    abstract Snapshot<T> getInstances(T var1);

    abstract Snapshot<T> getMetaComponents(T var1, T var2);

    abstract Snapshot<T> getSuperComponents(T var1, T var2);

    abstract V unwrap(T var1);

    abstract T wrap(V var1);
}

