/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.genericsystem.cache.AbstractGeneric;
import org.genericsystem.kernel.AbstractVertex;

public class TransactionCache<T extends AbstractGeneric<T, ?, V, ?>, V extends AbstractVertex<V, ?>>
extends HashMap<T, V> {
    private static final long serialVersionUID = -2571113223711253002L;
    private final Map<V, T> reverseMap = new HashMap<V, T>();

    public TransactionCache(T engine) {
        assert (((AbstractGeneric)engine).unwrap() != null);
        this.put(engine, (V)((AbstractGeneric)engine).unwrap());
    }

    @Override
    public V get(Object key) {
        AbstractGeneric generic = (AbstractGeneric)key;
        AbstractVertex result = (AbstractVertex)super.get(generic);
        if (result == null) {
            V pluggedMeta = this.get(generic.getMeta());
            if (pluggedMeta != null) {
                for (AbstractVertex instance : pluggedMeta.getInstances()) {
                    if (!generic.equals(instance)) continue;
                    this.put((T)generic, (V)instance);
                    return (V)instance;
                }
            }
            this.put((T)generic, (V)null);
        }
        return (V)result;
    }

    @Override
    public V put(T key, V value) {
        AbstractVertex old = (AbstractVertex)super.put(key, value);
        this.reverseMap.put(value, key);
        if (old != null) {
            assert (!old.isAlive());
            this.reverseMap.put(old, null);
        }
        return (V)old;
    }

    T getByValue(V vertex) {
        assert (vertex.isAlive());
        AbstractVertex alive = (AbstractVertex)vertex.getAlive();
        AbstractGeneric result = (AbstractGeneric)this.reverseMap.get(alive);
        if (result == null) {
            assert (alive.getMeta() != alive) : this;
            T meta = this.getByValue((AbstractVertex)alive.getMeta());
            result = ((AbstractGeneric)meta).newT(null, alive.isThrowExistException(), meta, alive.getSupersStream().map(this::getByValue).collect(Collectors.toList()), alive.getValue(), alive.getComponentsStream().map(this::getByValue).collect(Collectors.toList()));
            this.put((T)result, (V)alive);
        }
        return (T)result;
    }
}

