/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.genericsystem.kernel.Dependencies;
import org.genericsystem.kernel.iterator.AbstractConcateIterator;
import org.genericsystem.kernel.iterator.AbstractFilterIterator;

public class CacheDependencies<T>
implements Dependencies<T> {
    private final Set<T> inserts = new LinkedHashSet<T>();
    private final Set<T> deletes = new LinkedHashSet<T>();
    private final Supplier<Iterator<T>> iteratorSupplier;

    public CacheDependencies(Supplier<Iterator<T>> iteratorSupplier) {
        this.iteratorSupplier = iteratorSupplier;
    }

    public void add(T generic) {
        this.inserts.add(generic);
    }

    public boolean remove(T generic) {
        if (!this.inserts.remove(generic)) {
            return this.deletes.add(generic);
        }
        return true;
    }

    public Iterator<T> iterator() {
        return new AbstractConcateIterator.ConcateIterator(new Iterator[]{new AbstractFilterIterator<T>(this.iteratorSupplier.get()){

            public boolean isSelected() {
                return !CacheDependencies.this.deletes.contains(this.next);
            }
        }, this.inserts.iterator()});
    }

    public String toString() {
        return this.stream().collect(Collectors.toList()).toString();
    }
}

