/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.genericsystem.cache.AbstractContext;
import org.genericsystem.cache.AbstractGeneric;
import org.genericsystem.cache.CacheDependencies;
import org.genericsystem.cache.EngineService;
import org.genericsystem.cache.GenericsCache;
import org.genericsystem.cache.RootService;
import org.genericsystem.cache.Transaction;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.Dependencies;
import org.genericsystem.kernel.Snapshot;
import org.genericsystem.kernel.Statics;
import org.genericsystem.kernel.exceptions.ConcurrencyControlException;
import org.genericsystem.kernel.exceptions.ConstraintViolationException;
import org.genericsystem.kernel.exceptions.NotFoundException;
import org.genericsystem.kernel.exceptions.RollbackException;

public class Cache<T extends AbstractGeneric<T, U, V, W>, U extends EngineService<T, U, V, W>, V extends AbstractVertex<V, W>, W extends RootService<V, W>>
extends AbstractContext<T, U, V, W> {
    protected AbstractContext<T, U, V, W> subContext;
    private transient Map<T, Dependencies<T>> inheritingsDependenciesMap;
    private transient Map<T, Dependencies<T>> instancesDependenciesMap;
    private transient Map<T, Map<T, Dependencies<T>>> metaCompositesDependenciesMap;
    private transient Map<T, Map<T, Dependencies<T>>> superCompositesDependenciesMap;
    protected Set<T> adds = new LinkedHashSet<T>();
    protected Set<T> removes = new LinkedHashSet<T>();
    private final GenericsCache<T> genericsCache = new GenericsCache();

    public void clear() {
        this.inheritingsDependenciesMap = new HashMap<T, Dependencies<T>>();
        this.instancesDependenciesMap = new HashMap<T, Dependencies<T>>();
        this.metaCompositesDependenciesMap = new HashMap<T, Map<T, Dependencies<T>>>();
        this.superCompositesDependenciesMap = new HashMap<T, Map<T, Dependencies<T>>>();
        this.adds = new LinkedHashSet<T>();
        this.removes = new LinkedHashSet<T>();
    }

    protected Cache(U engine) {
        this(new Transaction(engine));
    }

    protected Cache(AbstractContext<T, U, V, W> subContext) {
        this.subContext = subContext;
        this.clear();
    }

    @Override
    public boolean isAlive(T generic) {
        return this.adds.contains(generic) || !this.removes.contains(generic) && this.getSubContext().isAlive(generic);
    }

    public Cache<T, U, V, W> mountNewCache() {
        return this.getEngine().buildCache(this).start();
    }

    public Cache<T, U, V, W> flushAndUnmount() {
        this.flush();
        return this.subContext instanceof Cache ? ((Cache)this.subContext).start() : this;
    }

    public Cache<T, U, V, W> clearAndUnmount() {
        this.clear();
        return this.subContext instanceof Cache ? ((Cache)this.subContext).start() : this;
    }

    public Cache<T, U, V, W> start() {
        return this.getEngine().start(this);
    }

    public void stop() {
        this.getEngine().stop(this);
    }

    public void flush() throws RollbackException {
        try {
            this.internalFlush();
        }
        catch (Exception e) {
            this.getEngine().discardWithException(e);
        }
        this.clear();
    }

    protected void rollbackWithException(Throwable exception) throws RollbackException {
        this.clear();
        throw new RollbackException(exception);
    }

    protected void internalFlush() throws ConcurrencyControlException, ConstraintViolationException {
        this.getSubContext().apply(this.adds, this.removes);
    }

    @Override
    protected void apply(Iterable<T> adds, Iterable<T> removes) throws ConcurrencyControlException, ConstraintViolationException {
        for (AbstractGeneric remove : removes) {
            this.unplug(remove);
        }
        for (AbstractGeneric add : adds) {
            this.plug(add);
        }
    }

    T insert(T generic) throws RollbackException {
        try {
            this.add(generic);
            return generic;
        }
        catch (ConstraintViolationException e) {
            this.getEngine().discardWithException(e);
            throw new IllegalStateException();
        }
    }

    private void add(T generic) throws ConstraintViolationException {
        this.simpleAdd(generic);
    }

    @Override
    protected void simpleAdd(T generic) {
        if (!this.removes.remove(generic)) {
            this.adds.add(generic);
        }
    }

    @Override
    protected boolean simpleRemove(T generic) {
        if (!this.isAlive(generic)) {
            this.getEngine().discardWithException(new IllegalStateException(generic + " is not alive"));
        }
        if (!this.adds.remove(generic)) {
            return this.removes.add(generic);
        }
        return true;
    }

    @Override
    public U getEngine() {
        return this.subContext.getEngine();
    }

    protected AbstractContext<T, U, V, W> getSubContext() {
        return this.subContext;
    }

    private Snapshot<T> getDependencies(Map<T, Dependencies<T>> multiMap, Supplier<Iterator<T>> subIteratorSupplier, T generic) {
        return () -> {
            Dependencies dependencies = (Dependencies)multiMap.get(generic);
            return dependencies == null ? (Iterator)subIteratorSupplier.get() : dependencies.iterator();
        };
    }

    @Override
    Snapshot<T> getInstances(T generic) {
        return this.getDependencies(this.instancesDependenciesMap, () -> this.subContext.getInstances((AbstractGeneric)generic).iterator(), generic);
    }

    @Override
    Snapshot<T> getInheritings(T generic) {
        return this.getDependencies(this.inheritingsDependenciesMap, () -> this.subContext.getInheritings((AbstractGeneric)generic).iterator(), generic);
    }

    private T index(Map<T, Dependencies<T>> multiMap, Supplier<Iterator<T>> subIteratorSupplier, T generic, T dependency) {
        Dependencies<T> dependencies = multiMap.get(generic);
        if (dependencies == null) {
            dependencies = new CacheDependencies<T>(subIteratorSupplier);
            multiMap.put(generic, dependencies);
        }
        return (T)((AbstractGeneric)dependencies.set(dependency));
    }

    private boolean unIndex(Map<T, Dependencies<T>> multiMap, Supplier<Iterator<T>> subIteratorSupplier, T generic, T dependency) {
        Dependencies<T> dependencies = multiMap.get(generic);
        if (dependencies == null) {
            dependencies = new CacheDependencies<T>(subIteratorSupplier);
            multiMap.put(generic, dependencies);
        }
        return dependencies.remove(dependency);
    }

    private T indexInstance(T generic, T instance) {
        return this.index(this.instancesDependenciesMap, () -> this.subContext.getInstances((AbstractGeneric)generic).iterator(), generic, instance);
    }

    private T indexInheriting(T generic, T inheriting) {
        return this.index(this.inheritingsDependenciesMap, () -> this.subContext.getInheritings((AbstractGeneric)generic).iterator(), generic, inheriting);
    }

    private boolean unIndexInstance(T generic, T instance) {
        return this.unIndex(this.instancesDependenciesMap, () -> this.subContext.getInstances((AbstractGeneric)generic).iterator(), generic, instance);
    }

    private boolean unIndexInheriting(T generic, T inheriting) {
        return this.unIndex(this.inheritingsDependenciesMap, () -> this.subContext.getInheritings((AbstractGeneric)generic).iterator(), generic, inheriting);
    }

    Snapshot<T> getComposites(T generic) {
        return () -> {
            Map<T, Dependencies<T>> dependencies = this.metaCompositesDependenciesMap.get(generic);
            return dependencies == null ? Collections.emptyIterator() : Statics.concat(this.metaCompositesDependenciesMap.get(generic).entrySet().stream(), x -> ((Dependencies)x.getValue()).stream()).iterator();
        };
    }

    @Override
    Snapshot<T> getMetaComposites(T generic, T meta) {
        return Cache.getIndex(this.metaCompositesDependenciesMap, () -> this.subContext.getMetaComposites((AbstractGeneric)generic, (AbstractGeneric)meta).iterator(), generic, meta);
    }

    @Override
    Snapshot<T> getSuperComposites(T generic, T superT) {
        return Cache.getIndex(this.superCompositesDependenciesMap, () -> this.subContext.getSuperComposites((AbstractGeneric)generic, (AbstractGeneric)superT).iterator(), generic, superT);
    }

    private T indexByMeta(T generic, T meta, T composite) {
        return (T)((AbstractGeneric)Cache.index(this.metaCompositesDependenciesMap, () -> this.subContext.getMetaComposites((AbstractGeneric)generic, (AbstractGeneric)meta).iterator(), generic, meta, composite));
    }

    private T indexBySuper(T generic, T superT, T composite) {
        return (T)((AbstractGeneric)Cache.index(this.superCompositesDependenciesMap, () -> this.subContext.getSuperComposites((AbstractGeneric)generic, (AbstractGeneric)superT).iterator(), generic, superT, composite));
    }

    private boolean unIndexByMeta(T generic, T meta, T composite) {
        return Cache.unIndex(this.metaCompositesDependenciesMap, () -> this.subContext.getMetaComposites((AbstractGeneric)generic, (AbstractGeneric)meta).iterator(), generic, meta, composite);
    }

    private boolean unIndexBySuper(T generic, T superT, T composite) {
        return Cache.unIndex(this.superCompositesDependenciesMap, () -> this.subContext.getSuperComposites((AbstractGeneric)generic, (AbstractGeneric)superT).iterator(), generic, superT, composite);
    }

    private static <T> Snapshot<T> getIndex(Map<T, Map<T, Dependencies<T>>> multiMap, Supplier<Iterator<T>> subIteratorSupplier, T generic, T index) {
        return () -> {
            Map dependencies = (Map)multiMap.get(generic);
            if (dependencies == null) {
                return (Iterator)subIteratorSupplier.get();
            }
            Dependencies dependenciesByIndex = (Dependencies)dependencies.get(index);
            if (dependenciesByIndex == null) {
                return (Iterator)subIteratorSupplier.get();
            }
            return dependenciesByIndex.iterator();
        };
    }

    private static <T> T index(Map<T, Map<T, Dependencies<T>>> multiMap, Supplier<Iterator<T>> subIteratorSupplier, T generic, T index, T composite) {
        Dependencies<T> dependenciesByIndex;
        Map<T, Dependencies<T>> dependencies = multiMap.get(generic);
        if (dependencies == null) {
            dependencies = new HashMap<T, Dependencies<T>>();
            multiMap.put(generic, dependencies);
        }
        if ((dependenciesByIndex = dependencies.get(index)) == null) {
            dependenciesByIndex = new CacheDependencies<T>(subIteratorSupplier);
            dependencies.put(index, dependenciesByIndex);
        }
        return (T)dependenciesByIndex.set(composite);
    }

    private static <T> boolean unIndex(Map<T, Map<T, Dependencies<T>>> multiMap, Supplier<Iterator<T>> subIteratorSupplier, T generic, T index, T composite) {
        Dependencies<T> dependenciesByIndex;
        Map<T, Dependencies<T>> dependencies = multiMap.get(generic);
        if (dependencies == null) {
            dependencies = new HashMap<T, Dependencies<T>>();
            multiMap.put(generic, dependencies);
        }
        if ((dependenciesByIndex = dependencies.get(index)) == null) {
            dependenciesByIndex = new CacheDependencies<T>(subIteratorSupplier);
            dependencies.put(index, dependenciesByIndex);
        }
        return dependenciesByIndex.remove(composite);
    }

    T plug(T generic) {
        AbstractGeneric t = this.indexInstance((AbstractGeneric)generic.getMeta(), generic);
        generic.getSupersStream().forEach(superGeneric -> this.indexInheriting(superGeneric, generic));
        generic.getComponentsStream().forEach(component -> this.indexByMeta(component, (AbstractGeneric)generic.getMeta(), generic));
        generic.getSupersStream().forEach(superGeneric -> generic.getComponentsStream().forEach(component -> this.indexBySuper(component, superGeneric, generic)));
        this.insert(generic);
        return (T)t;
    }

    boolean unplug(T generic) {
        boolean result = this.unIndexInstance((AbstractGeneric)generic.getMeta(), generic);
        if (!result) {
            this.getEngine().discardWithException((Throwable)new NotFoundException(generic.info()));
        }
        generic.getSupersStream().forEach(superGeneric -> this.unIndexInheriting(superGeneric, generic));
        generic.getComponentsStream().forEach(component -> this.unIndexByMeta(component, (AbstractGeneric)generic.getMeta(), generic));
        generic.getSupersStream().forEach(superGeneric -> generic.getComponentsStream().forEach(component -> this.unIndexBySuper(component, superGeneric, generic)));
        return result && this.simpleRemove(generic);
    }

    @Override
    V unwrap(T generic) {
        return this.getSubContext().unwrap(generic);
    }

    @Override
    T wrap(V vertex) {
        return this.getSubContext().wrap(vertex);
    }

    public <subT extends T> subT getOrBuildT(Class<?> clazz, boolean throwExistException, T meta, List<T> supers, Serializable value, List<T> components) {
        return this.genericsCache.getOrBuildT(clazz, throwExistException, meta, supers, value, components);
    }
}

