/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import org.genericsystem.cache.AbstractGeneric;
import org.genericsystem.cache.EngineService;
import org.genericsystem.cache.RootService;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.Snapshot;
import org.genericsystem.kernel.exceptions.ConcurrencyControlException;
import org.genericsystem.kernel.exceptions.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContext<T extends AbstractGeneric<T, U, V, W>, U extends EngineService<T, U, V, W>, V extends AbstractVertex<V, W>, W extends RootService<V, W>> {
    static Logger log = LoggerFactory.getLogger(AbstractContext.class);

    public abstract U getEngine();

    public abstract boolean isAlive(T var1);

    protected void apply(Iterable<T> adds, Iterable<T> removes) throws ConcurrencyControlException, ConstraintViolationException {
        this.removeAll(removes);
        this.addAll(adds);
    }

    void addAll(Iterable<T> generics) {
        for (AbstractGeneric generic : generics) {
            this.simpleAdd(generic);
        }
    }

    void removeAll(Iterable<T> generics) {
        for (AbstractGeneric generic : generics) {
            this.simpleRemove(generic);
        }
    }

    protected abstract void simpleAdd(T var1);

    protected abstract boolean simpleRemove(T var1);

    abstract Snapshot<T> getInheritings(T var1);

    abstract Snapshot<T> getInstances(T var1);

    abstract Snapshot<T> getMetaComposites(T var1, T var2);

    abstract Snapshot<T> getSuperComposites(T var1, T var2);

    abstract V unwrap(T var1);

    abstract T wrap(V var1);
}

