/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.util.Collections;
import java.util.stream.Collectors;
import org.genericsystem.cache.AbstractContext;
import org.genericsystem.cache.AbstractGeneric;
import org.genericsystem.cache.EngineService;
import org.genericsystem.cache.RootService;
import org.genericsystem.cache.TransactionCache;
import org.genericsystem.kernel.AbstractVertex;
import org.genericsystem.kernel.Snapshot;
import org.genericsystem.kernel.exceptions.ConcurrencyControlException;
import org.genericsystem.kernel.exceptions.ConstraintViolationException;

public class Transaction<T extends AbstractGeneric<T, U, V, W>, U extends EngineService<T, U, V, W>, V extends AbstractVertex<V, W>, W extends RootService<V, W>>
extends AbstractContext<T, U, V, W> {
    private final transient U engine;
    protected final TransactionCache<T, V> vertices;

    protected Transaction(U engine) {
        this.engine = engine;
        this.vertices = new TransactionCache((AbstractGeneric)engine);
    }

    @Override
    public boolean isAlive(T generic) {
        Object vertex = ((AbstractGeneric)generic).unwrap();
        return vertex != null && vertex.isAlive();
    }

    @Override
    protected void simpleAdd(T generic) {
        V vertex = this.unwrap((AbstractGeneric)generic.getMeta());
        AbstractVertex result = vertex.bindInstance(generic.isThrowExistException(), generic.getSupersStream().map(this::unwrap).collect(Collectors.toList()), generic.getValue(), generic.getComponentsStream().map(this::unwrap).collect(Collectors.toList()));
        this.vertices.put(generic, result);
    }

    @Override
    protected boolean simpleRemove(T generic) {
        ((AbstractGeneric)generic).unwrap().remove();
        this.vertices.put(generic, (Object)null);
        return true;
    }

    @Override
    public U getEngine() {
        return this.engine;
    }

    @Override
    Snapshot<T> getInheritings(T generic) {
        return () -> {
            V vertex = this.unwrap(generic);
            return vertex != null ? vertex.getInheritings().stream().map(generic::wrap).iterator() : Collections.emptyIterator();
        };
    }

    @Override
    Snapshot<T> getInstances(T generic) {
        return () -> {
            V vertex = this.unwrap(generic);
            return vertex != null ? vertex.getInstances().stream().map(generic::wrap).iterator() : Collections.emptyIterator();
        };
    }

    @Override
    Snapshot<T> getMetaComposites(T generic, T meta) {
        return () -> {
            V genericVertex = this.unwrap(generic);
            V metaVertex = this.unwrap(meta);
            return genericVertex != null && metaVertex != null ? genericVertex.getMetaComposites(metaVertex).stream().map(generic::wrap).iterator() : Collections.emptyIterator();
        };
    }

    @Override
    Snapshot<T> getSuperComposites(T generic, T superT) {
        return () -> {
            V genericVertex = this.unwrap(generic);
            V superVertex = this.unwrap(superT);
            return genericVertex != null && superVertex != null ? genericVertex.getSuperComposites(superVertex).stream().map(generic::wrap).iterator() : Collections.emptyIterator();
        };
    }

    @Override
    protected V unwrap(T generic) {
        return this.vertices.get(generic);
    }

    @Override
    protected void apply(Iterable<T> adds, Iterable<T> removes) throws ConcurrencyControlException, ConstraintViolationException {
        super.apply(adds, removes);
    }

    @Override
    T wrap(V vertex) {
        return this.vertices.getByValue(vertex);
    }
}

