/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.util.stream.Collectors;
import org.genericsystem.cache.Context;
import org.genericsystem.cache.EngineService;
import org.genericsystem.cache.GenericService;
import org.genericsystem.kernel.Dependencies;
import org.genericsystem.kernel.Vertex;
import org.genericsystem.kernel.services.SignatureService;
import org.genericsystem.kernel.services.UpdatableService;

public class Transaction<T extends GenericService<T, U>, U extends EngineService<T, U>>
implements Context<T, U> {
    private final transient EngineService<T, U> engine;

    public Transaction(EngineService<T, U> engine) {
        this.engine = engine;
    }

    @Override
    public boolean isAlive(T generic) {
        return generic.getVertex() != null && generic.getVertex().isAlive();
    }

    @Override
    public void simpleAdd(T generic) {
        ((GenericService)generic.getMeta()).getVertex().addInstance(generic.getSupersStream().map(g -> g.unwrap()).collect(Collectors.toList()), generic.getValue(), (UpdatableService[])generic.getComponentsStream().map(g -> g.unwrap()).toArray(Vertex[]::new));
    }

    @Override
    public void simpleRemove(T generic) {
    }

    @Override
    public EngineService<T, U> getEngine() {
        return this.engine;
    }

    @Override
    public Dependencies<T> getInheritings(T generic) {
        return generic.unwrap().getInheritings().project(arg_0 -> generic.wrap(arg_0), org.genericsystem.impl.GenericService::unwrap, SignatureService::isAlive);
    }

    @Override
    public Dependencies<T> getInstances(T generic) {
        return generic.unwrap().getInstances().project(arg_0 -> generic.wrap(arg_0), org.genericsystem.impl.GenericService::unwrap, SignatureService::isAlive);
    }

    @Override
    public Dependencies.CompositesDependencies<T> getMetaComposites(T generic) {
        return generic.unwrap().getMetaComposites().projectComposites(arg_0 -> generic.wrap(arg_0), org.genericsystem.impl.GenericService::unwrap, SignatureService::isAlive);
    }

    @Override
    public Dependencies.CompositesDependencies<T> getSuperComposites(T generic) {
        return generic.unwrap().getSuperComposites().projectComposites(arg_0 -> generic.wrap(arg_0), org.genericsystem.impl.GenericService::unwrap, SignatureService::isAlive);
    }
}

