/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Supplier;
import org.genericsystem.cache.Cache;
import org.genericsystem.cache.CacheDependencies;
import org.genericsystem.cache.EngineService;
import org.genericsystem.kernel.Dependencies;
import org.genericsystem.kernel.Snapshot;
import org.genericsystem.kernel.services.SignatureService;
import org.genericsystem.kernel.services.SystemPropertiesService;
import org.genericsystem.kernel.services.UpdatableService;

public interface GenericService<T extends GenericService<T, U>, U extends EngineService<T, U>>
extends org.genericsystem.impl.GenericService<T, U> {
    default public Dependencies<T> getInstances() {
        return this.getCurrentCache().getInstances(this);
    }

    default public Dependencies<T> getInheritings() {
        return this.getCurrentCache().getInheritings(this);
    }

    default public Dependencies.CompositesDependencies<T> getMetaComposites() {
        return this.getCurrentCache().getMetaComposites(this);
    }

    default public Dependencies.CompositesDependencies<T> getSuperComposites() {
        return this.getCurrentCache().getSuperComposites(this);
    }

    default public Snapshot<T> getMetaComposites(T meta) {
        return this.getCurrentCache().getMetaComposites(this).getByIndex(meta);
    }

    default public Snapshot<T> getSuperComposites(T superVertex) {
        return this.getCurrentCache().getSuperComposites(this).getByIndex(superVertex);
    }

    default public T getInstance(Serializable value, T ... components) {
        GenericService nearestMeta = (GenericService)this.adjustMeta(Collections.emptyList(), value, Arrays.asList(components));
        if (nearestMeta != this) {
            return (T)nearestMeta.getInstance(value, (GenericService[])components);
        }
        for (GenericService instance : this.getCurrentCache().getInstances(nearestMeta)) {
            if (!instance.equiv((SignatureService)this, value, Arrays.asList(components))) continue;
            return (T)instance;
        }
        return null;
    }

    default public void setSystemPropertyValue(Class<T> propertyClass, int pos, Serializable value) {
        GenericService root = (GenericService)this.getRoot();
        ((GenericService)root.setInstance((UpdatableService)this.getMap(), (Serializable)new SystemPropertiesService.AxedPropertyClass(propertyClass, pos), (UpdatableService[])new GenericService[]{root})).setInstance(value, (UpdatableService[])new GenericService[]{this});
    }

    default public boolean isAlive() {
        return this.getCurrentCache().isAlive(this);
    }

    default public T getAlive() {
        if (this.isAlive()) {
            return (T)this;
        }
        return null;
    }

    default public <U extends T> CacheDependencies<U> buildDependencies(Supplier<Iterator<T>> subDependenciesSupplier) {
        return new CacheDependencies<T>(subDependenciesSupplier);
    }

    default public Cache<T, U> getCurrentCache() {
        return ((GenericService)this.getRoot()).getCurrentCache();
    }

    default public T plug() {
        return (T)this.getCurrentCache().insert((GenericService)super.plug());
    }

    default public boolean unplug() {
        boolean unplugged = super.unplug();
        this.getCurrentCache().simpleRemove(this);
        return unplugged;
    }
}

