/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.util.Iterator;
import java.util.function.Supplier;
import org.genericsystem.kernel.Dependencies;
import org.genericsystem.kernel.DependenciesImpl;
import org.genericsystem.kernel.iterator.AbstractConcateIterator;
import org.genericsystem.kernel.iterator.AbstractFilterIterator;

public class CacheDependencies<T>
implements Dependencies<T> {
    private final Dependencies<T> inserts = new DependenciesImpl();
    private final Dependencies<T> deletes = new DependenciesImpl();
    private final Supplier<Iterator<T>> iteratorSupplier;

    public CacheDependencies(Supplier<Iterator<T>> iteratorSupplier) {
        this.iteratorSupplier = iteratorSupplier;
    }

    public void add(T generic) {
        this.inserts.add(generic);
    }

    public boolean remove(T generic) {
        if (this.inserts.remove(generic)) {
            this.deletes.add(generic);
            return true;
        }
        return false;
    }

    public Iterator<T> iterator() {
        return new AbstractConcateIterator.ConcateIterator(new Iterator[]{new AbstractFilterIterator<T>(this.iteratorSupplier.get()){

            public boolean isSelected() {
                return !CacheDependencies.this.deletes.contains(this.next);
            }
        }, this.inserts.iterator()});
    }
}

