/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.genericsystem.cache.Context;
import org.genericsystem.cache.EngineService;
import org.genericsystem.cache.GenericService;
import org.genericsystem.cache.Transaction;
import org.genericsystem.kernel.Dependencies;
import org.genericsystem.kernel.exceptions.ConcurrencyControlException;
import org.genericsystem.kernel.exceptions.ConstraintViolationException;
import org.genericsystem.kernel.exceptions.RollbackException;

public class Cache<T extends GenericService<T, U>, U extends EngineService<T, U>>
implements Context<T, U> {
    protected Context<T, U> subContext;
    private transient Map<T, Dependencies<T>> inheritingDependenciesMap = new HashMap<T, Dependencies<T>>();
    private transient Map<T, Dependencies<T>> instancesDependenciesMap = new HashMap<T, Dependencies<T>>();
    private transient Map<T, Dependencies.CompositesDependencies<T>> metaCompositesDependenciesMap = new HashMap<T, Dependencies.CompositesDependencies<T>>();
    private transient Map<T, Dependencies.CompositesDependencies<T>> superCompositesDependenciesMap = new HashMap<T, Dependencies.CompositesDependencies<T>>();
    private Set<T> adds = new LinkedHashSet<T>();
    private Set<T> removes = new LinkedHashSet<T>();

    void clear() {
        this.inheritingDependenciesMap = new HashMap<T, Dependencies<T>>();
        this.instancesDependenciesMap = new HashMap<T, Dependencies<T>>();
        this.metaCompositesDependenciesMap = new HashMap<T, Dependencies.CompositesDependencies<T>>();
        this.superCompositesDependenciesMap = new HashMap<T, Dependencies.CompositesDependencies<T>>();
        this.adds = new LinkedHashSet<T>();
        this.removes = new LinkedHashSet<T>();
    }

    public Cache(EngineService<T, U> engine) {
        this(new Transaction<T, U>(engine));
    }

    public Cache(Context<T, U> subContext) {
        this.subContext = subContext;
        this.clear();
    }

    @Override
    public boolean isAlive(T generic) {
        return this.adds.contains(generic) || !this.removes.contains(generic) && this.getSubContext().isAlive(generic);
    }

    public Cache<T, U> mountNewCache() {
        return this.getEngine().buildCache(this).start();
    }

    public Cache<T, U> flushAndUnmount() {
        this.flush();
        return this.subContext instanceof Cache ? ((Cache)this.subContext).start() : this;
    }

    public Cache<T, U> discardAndUnmount() {
        this.clear();
        return this.subContext instanceof Cache ? ((Cache)this.subContext).start() : this;
    }

    public Cache<T, U> start() {
        return this.getEngine().start(this);
    }

    public void stop() {
        this.getEngine().stop(this);
    }

    public T insert(T generic) throws RollbackException {
        try {
            this.add(generic);
            return generic;
        }
        catch (ConstraintViolationException e) {
            this.rollback(e);
            throw new IllegalStateException();
        }
    }

    public void flush() throws RollbackException {
        ConcurrencyControlException cause = null;
        for (int attempt = 0; attempt < 50; ++attempt) {
            try {
                this.getSubContext().apply(this.adds, this.removes);
                this.clear();
                return;
            }
            catch (ConcurrencyControlException e) {
                cause = e;
                try {
                    Thread.sleep(15L);
                    continue;
                }
                catch (InterruptedException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            catch (Exception e) {
                this.rollback(e);
            }
        }
        this.rollback(cause);
    }

    private void add(T generic) throws ConstraintViolationException {
        this.simpleAdd(generic);
    }

    @Override
    public void simpleAdd(T generic) {
        if (!this.removes.remove(generic)) {
            this.adds.add(generic);
        }
    }

    @Override
    public void simpleRemove(T generic) {
        if (!this.isAlive(generic)) {
            this.rollback(new IllegalStateException(generic + " is not alive"));
        }
        if (!this.adds.remove(generic)) {
            this.removes.add(generic);
        }
    }

    void rollback(Throwable e) throws RollbackException {
        this.clear();
        throw new RollbackException(e);
    }

    @Override
    public Dependencies<T> getInheritings(T generic) {
        return this.getDependencies(generic, this.inheritingDependenciesMap, () -> this.iteratorFromAlive(generic, () -> this.subContext.getInheritings((GenericService)generic).iterator()));
    }

    @Override
    public Dependencies<T> getInstances(T generic) {
        return this.getDependencies(generic, this.instancesDependenciesMap, () -> this.iteratorFromAlive(generic, () -> this.subContext.getInstances((GenericService)generic).iterator()));
    }

    @Override
    public Dependencies.CompositesDependencies<T> getMetaComposites(T generic) {
        return this.getCompositesDependencies(generic, this.metaCompositesDependenciesMap, () -> this.iteratorFromAlivecomposite(generic, () -> this.subContext.getMetaComposites((GenericService)generic).iterator()));
    }

    @Override
    public Dependencies.CompositesDependencies<T> getSuperComposites(T generic) {
        return this.getCompositesDependencies(generic, this.superCompositesDependenciesMap, () -> this.iteratorFromAlivecomposite(generic, () -> this.subContext.getSuperComposites((GenericService)generic).iterator()));
    }

    protected Dependencies<T> getDependencies(T generic, Map<T, Dependencies<T>> dependenciesMap, Supplier<Iterator<T>> iteratorSupplier) {
        Dependencies dependencies = dependenciesMap.get(generic);
        if (dependencies == null) {
            dependencies = generic.buildDependencies((Supplier)iteratorSupplier);
            dependenciesMap.put(generic, dependencies);
        }
        return dependencies;
    }

    protected Dependencies.CompositesDependencies<T> getCompositesDependencies(T generic, Map<T, Dependencies.CompositesDependencies<T>> dependenciesMap, Supplier<Iterator<Dependencies.DependenciesEntry<T>>> iteratorSupplier) {
        Dependencies.CompositesDependencies dependencies = dependenciesMap.get(generic);
        if (dependencies == null) {
            dependencies = generic.buildCompositeDependencies(iteratorSupplier);
            dependenciesMap.put(generic, dependencies);
        }
        return dependencies;
    }

    private Iterator<T> iteratorFromAlive(T generic, Supplier<Iterator<T>> supplier) {
        return generic.getVertex() == null ? Collections.emptyIterator() : supplier.get();
    }

    private Iterator<Dependencies.DependenciesEntry<T>> iteratorFromAlivecomposite(T generic, Supplier<Iterator<Dependencies.DependenciesEntry<T>>> supplier) {
        return generic.getVertex() == null ? Collections.emptyIterator() : supplier.get();
    }

    @Override
    public EngineService<T, U> getEngine() {
        return this.subContext.getEngine();
    }

    public Context<T, U> getSubContext() {
        return this.subContext;
    }
}

