/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.core;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import org.genericsystem.api.core.FiltersBuilder;
import org.genericsystem.api.core.IGeneric;

public class IndexFilter {
    private final FiltersBuilder.FilterGetter getFilter;
    private final Object[] params;

    public IndexFilter(FiltersBuilder.FilterGetter getFilter, Object ... params) {
        this.getFilter = getFilter;
        this.params = params;
    }

    public final boolean test(IGeneric<?> generic) {
        return ((Predicate)this.getFilter.apply(this.params)).test(generic);
    }

    public int hashCode() {
        return this.getFilter.hashCode() * 31 + (this.params.length == 0 ? 0 : this.params[0].hashCode());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IndexFilter)) {
            return false;
        }
        IndexFilter other = (IndexFilter)obj;
        return this.getFilter == other.getFilter && Objects.deepEquals(this.params, other.params);
    }

    public boolean isAlive() {
        return Arrays.asList(this.params).stream().allMatch(param -> !(param instanceof IGeneric) || ((IGeneric)param).isAlive());
    }
}

