/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.tools;

import io.reactivex.Observable;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.genericsystem.api.core.IGeneric;
import org.genericsystem.api.core.IndexFilter;
import org.genericsystem.api.core.Snapshot;

public class Memoizer {
    public static Function<Snapshot<?>, Function<IndexFilter, Snapshot<?>>> getIndexFilterM = Memoizer.memoize(snapshot -> indexFilter -> Memoizer.getSnapshotFilterM(snapshot).apply((IndexFilter)indexFilter));
    public static Function<Snapshot<?>, Function<List<IndexFilter>, Snapshot<?>>> getIndexListFilterM = Memoizer.memoize(snapshot -> filters -> Memoizer.getSnapshotListFilterM(snapshot).apply((List<IndexFilter>)filters));

    public static <T, U> Function<T, U> memoize(Function<T, U> function) {
        ConcurrentHashMap cache = new ConcurrentHashMap();
        return t -> {
            if (cache.containsKey(t)) {
                return cache.get(t);
            }
            Object result = function.apply(t);
            cache.put(t, result);
            return result;
        };
    }

    public static <T> Function<IndexFilter, Snapshot<T>> getSnapshotFilterM(Snapshot<T> parent) {
        return Memoizer.memoize(filter -> new Snapshot<T>((IndexFilter)filter, parent){
            private Observable adds = this.getParent().getAdds().filter(g -> this.val$filter.test((IGeneric)g)).share();
            private Observable removals = this.getParent().getRemovals().filter(g -> this.val$filter.test((IGeneric)g)).share();
            final /* synthetic */ IndexFilter val$filter;
            final /* synthetic */ Snapshot val$parent;
            {
                this.val$filter = indexFilter;
                this.val$parent = snapshot;
            }

            @Override
            public Snapshot<T> getParent() {
                return this.val$parent;
            }

            @Override
            public IndexFilter getFilter() {
                return this.val$filter;
            }

            @Override
            public Comparator<T> getComparator() {
                return this.val$parent.getComparator();
            }

            @Override
            public Observable<T> getAdds() {
                return this.adds;
            }

            @Override
            public Observable<T> getRemovals() {
                return this.removals;
            }

            @Override
            public Stream<T> unfilteredStream() {
                throw new UnsupportedOperationException("unfilteredStream() should be called only on unfiltered snapshots.");
            }
        });
    }

    public static <T> Function<List<IndexFilter>, Snapshot<T>> getSnapshotListFilterM(final Snapshot<T> parent) {
        return Memoizer.memoize(filters -> new Snapshot<T>((List)filters){
            private Observable adds;
            private Observable removals;
            final /* synthetic */ List val$filters;
            {
                this.val$filters = list;
                this.adds = parent.getAdds().filter(g -> this.val$filters.stream().allMatch(filter -> filter.test((IGeneric)g))).share();
                this.removals = parent.getRemovals().filter(g -> this.val$filters.stream().allMatch(filter -> filter.test((IGeneric)g))).share();
            }

            @Override
            public Stream<T> unfilteredStream() {
                return parent.stream().filter((? super T g) -> this.val$filters.stream().allMatch(filter -> filter.test((IGeneric)g)));
            }

            @Override
            public Comparator<T> getComparator() {
                return parent.getComparator();
            }

            @Override
            public Observable<T> getAdds() {
                return this.adds;
            }

            @Override
            public Observable<T> getRemovals() {
                return this.removals;
            }

            @Override
            public T get(Object o) {
                Object result = parent.get(o);
                return result != null && this.val$filters.stream().allMatch(filter -> filter.test((IGeneric)result)) ? (Object)result : null;
            }
        });
    }
}

