/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.core;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class TagAnnotation
implements Serializable {
    private static final long serialVersionUID = -2849507333202498923L;
    private Class<? extends Annotation> annotationClass;
    private Class<?>[] path;
    private int[] pos;
    private String name;

    public TagAnnotation(Class<? extends Annotation> annotationClass, Class<?>[] path, int[] pos) {
        this(annotationClass, path, pos, null);
    }

    public TagAnnotation(Class<? extends Annotation> annotationClass, Class<?>[] path, int[] pos, String name) {
        this.annotationClass = annotationClass;
        this.path = path;
        this.pos = pos;
        this.name = name;
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public Class<?>[] getPath() {
        return this.path;
    }

    public int[] getPos() {
        return this.pos;
    }

    public String getName() {
        return this.name;
    }

    public boolean equivs(TagAnnotation otherAnnotation) {
        return Objects.equals(this.annotationClass, otherAnnotation.annotationClass) && Objects.equals(this.name, otherAnnotation.name);
    }

    public int hashCode() {
        return this.annotationClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TagAnnotation)) {
            return false;
        }
        TagAnnotation other = (TagAnnotation)obj;
        return this.annotationClass.equals(other.annotationClass) && Objects.equals(this.name, other.name) && Objects.deepEquals(this.path, other.path) && Objects.deepEquals(this.pos, other.pos);
    }

    public String toString() {
        return "{ annotationClass: " + this.annotationClass.getSimpleName() + ", path: " + Arrays.toString(this.path) + ", pos: " + Arrays.stream(this.pos).boxed().collect(Collectors.toList()) + ", name: " + this.name + "}";
    }
}

