/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.genericsystem.api.core.IGeneric;

public class FiltersBuilder {
    public static final FilterGetter NO_FILTER = params -> x -> true;
    public static final FilterGetter INSTANCES = params -> x -> params[0].equals(x.getMeta());
    public static final FilterGetter INHERITINGS = params -> x -> x.getSupers().contains(params[0]);
    public static final FilterGetter COMPOSITES = params -> x -> x.getComponents().contains(params[0]);
    public static final FilterGetter HAS_META = params -> x -> !x.equals(params[0]) && ((IGeneric)x.getMeta()).equals(params[0]);
    public static final FilterGetter HAS_SUPER = params -> x -> x.getSupers().contains(params[0]);
    public static final FilterGetter HAS_COMPONENTS = params -> x -> FiltersBuilder.filter(x.getComponents(), Arrays.asList(params)).test((IGeneric<?>)x);
    public static final FilterGetter COMPOSITE_HAS_COMPONENTS = params -> x -> FiltersBuilder.componentsFilter(params).test((IGeneric<?>)x);
    public static final FilterGetter HAS_VALUE = params -> x -> Objects.equals(x.getValue(), params[0]);
    public static final FilterGetter HAS_SUPERS = params -> x -> ((Object[])params).length == 0 ? x.getSupers().isEmpty() : FiltersBuilder.filter(x.getSupers(), Arrays.asList(params)).test((IGeneric<?>)x);
    public static final FilterGetter HAS_COMPONENT_AT_POS = params -> holder -> holder.getComponent((Integer)params[1]) != null && ((IGeneric)params[0]).isSpecializationOf(holder.getComponent((Integer)params[1]));
    public static final FilterGetter IS_SPECIALIZATION_OF = params -> holder -> holder.isSpecializationOf((IGeneric)params[0]);
    public static final FilterGetter HAS_LEVEL = params -> holder -> holder.getLevel() == ((Integer)params[0]).intValue();
    public static final FilterGetter NOT_CONTAINED_IN_PARAM = params -> x -> !((Set)params[0]).contains(x);
    public static final FilterGetter IS_DIRECT_DEPENDENCY_OF = params -> x -> ((IGeneric)params[0]).isDirectAncestorOf(x);

    static Predicate<IGeneric<?>> filter(List<?> ancestors, List<Object> ancestorsReached) {
        return attribute -> {
            ArrayList attributeAncestors = new ArrayList(ancestors);
            for (Object ancestorsReach : ancestorsReached) {
                Object matchedComponent = attributeAncestors.stream().filter(attributeAncestor -> attributeAncestor.equals(ancestorsReach)).findFirst().orElse(null);
                if (matchedComponent != null) {
                    attributeAncestors.remove(matchedComponent);
                    continue;
                }
                return false;
            }
            return true;
        };
    }

    static <T extends IGeneric<T>> Predicate<IGeneric<?>> componentsFilter(Object ... componentsReached) {
        return attribute -> {
            ArrayList attributeComps = new ArrayList(attribute.getComponents());
            for (Object componentReach : componentsReached) {
                IGeneric matchedComponent = attributeComps.stream().filter(attributeComp -> ((IGeneric)componentsReached[0]).isSpecializationOf(attributeComp) ? true : componentReach.equals(attributeComp)).findFirst().orElse(null);
                if (matchedComponent == null) {
                    return false;
                }
                attributeComps.remove(matchedComponent);
            }
            return true;
        };
    }

    public static interface FilterGetter
    extends Function<Object[], Predicate<IGeneric<?>>> {
    }
}

