/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.core.annotations.constraints;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Iterator;
import java.util.List;
import org.genericsystem.api.core.IGeneric;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Inherited
public @interface InstanceValueGenerator {
    public Class<? extends ValueGenerator> value() default DefaultInstanceValueGenerator.class;

    public static class DefaultInstanceValueGenerator<T extends IGeneric<T>>
    implements ValueGenerator<T> {
        @Override
        public Serializable generateInstanceValue(T meta, List<T> supers, Serializable value, List<T> components) {
            return components.size() > 0 ? this.toString(components) : Integer.valueOf((int)(Math.random() * 2.147483647E9)).toString();
        }

        private String toString(List<T> components) {
            Iterator<T> it = components.iterator();
            if (!it.hasNext()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('<');
            while (true) {
                IGeneric e;
                sb.append((e = (IGeneric)it.next()) == this ? "(this Collection)" : e);
                if (!it.hasNext()) {
                    return sb.append('>').toString();
                }
                sb.append('-');
            }
        }
    }

    public static interface ValueGenerator<T extends IGeneric<T>> {
        public Serializable generateInstanceValue(T var1, List<T> var2, Serializable var3, List<T> var4);
    }
}

