/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.core;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.functions.Function;
import java.lang.invoke.MethodHandles;
import java.text.Collator;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.genericsystem.api.core.IndexFilter;
import org.genericsystem.api.tools.Memoizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface Snapshot<T>
extends Iterable<T> {
    public static <T> Snapshot<T> empty() {
        return new Snapshot<T>(){

            @Override
            public Stream<T> unfilteredStream() {
                return Stream.empty();
            }
        };
    }

    public static <T> Snapshot<T> singleton(final T element) {
        return new Snapshot<T>(){

            @Override
            public Stream<T> unfilteredStream() {
                return Stream.of(element);
            }
        };
    }

    public static <T> Snapshot<T> fromCollection(final Collection<T> elements) {
        return new Snapshot<T>(){

            @Override
            public Stream<T> unfilteredStream() {
                return elements.stream();
            }
        };
    }

    default public Snapshot<T> getParent() {
        return null;
    }

    default public IndexFilter getFilter() {
        return null;
    }

    @Override
    default public Iterator<T> iterator() {
        return this.stream().iterator();
    }

    default public Stream<T> stream() {
        LinkedList<IndexFilter> filters = new LinkedList<IndexFilter>();
        Snapshot<T> current = this;
        while (current.getParent() != null) {
            filters.add(0, current.getFilter());
            current = current.getParent();
        }
        if (!filters.isEmpty()) {
            return current.filter(filters).unfilteredStream();
        }
        return this.unfilteredStream();
    }

    public Stream<T> unfilteredStream();

    default public int size() {
        return (int)this.stream().count();
    }

    default public boolean isEmpty() {
        return this.stream().count() == 0L;
    }

    default public boolean contains(Object o) {
        return o.equals(this.get(o));
    }

    default public boolean containsAll(Collection<?> c) {
        return c.stream().allMatch(this::contains);
    }

    default public T get(Object o) {
        return this.stream().filter(o::equals).findFirst().orElse(null);
    }

    default public String info() {
        return this.stream().collect(Collectors.toList()).toString();
    }

    default public T first() {
        return this.iterator().hasNext() ? (T)this.iterator().next() : null;
    }

    default public T getByIndex(int index) {
        Iterator<T> iterator = this.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            if (index == i) {
                return iterator.next();
            }
            iterator.next();
            ++i;
        }
        return null;
    }

    default public Observable<T> getAdds() {
        return Observable.empty();
    }

    default public Observable<T> getRemovals() {
        return Observable.empty();
    }

    default public Comparator<T> getComparator() {
        return null;
    }

    default public Observable<IndexedElement<T>> getIndexedElements() {
        AbstractSet set = this.getComparator() != null ? new TreeSet<T>(this.getComparator()) : new HashSet();
        return Observable.merge((ObservableSource)Observable.concat((ObservableSource)Observable.fromIterable(this.toList()), this.getAdds()).map(g -> new TaggedElement<Object, ChangeType>(g, ChangeType.ADD)), (ObservableSource)this.getRemovals().map(g -> new TaggedElement<Object, ChangeType>(g, ChangeType.REMOVE))).scan(new TaggedElement<TreeSet<T>, Object>(set, null), (acc, change) -> {
            if (change.tag == ChangeType.ADD) {
                if (((Set)acc.element).add(change.element)) {
                    if (this.getComparator() != null) {
                        return new TaggedElement(acc.element, new IndexedElement(change.element, Collections.binarySearch(new ArrayList((Collection)acc.element), change.element, this.getComparator())));
                    }
                    return new TaggedElement(acc.element, new IndexedElement(change.element, new ArrayList((Collection)acc.element).indexOf(change.element)));
                }
                return new TaggedElement(acc.element, null);
            }
            ((Set)acc.element).remove(change.element);
            return new TaggedElement(acc.element, new IndexedElement(change.element, -1));
        }).filter(tagElt -> tagElt.tag != null).map(tagElt -> (IndexedElement)tagElt.tag);
    }

    default public Observable<Set<T>> setOnChanged() {
        AbstractSet set = this.getComparator() != null ? new TreeSet<T>(this.getComparator()) : new HashSet();
        set.addAll(this.toList());
        return Observable.merge((ObservableSource)this.getAdds().map(g -> new TaggedElement<Object, ChangeType>(g, ChangeType.ADD)), (ObservableSource)this.getRemovals().map(g -> new TaggedElement<Object, ChangeType>(g, ChangeType.REMOVE))).scan(new TaggedElement<AbstractSet, Boolean>(set, true), (acc, change) -> {
            if (change.tag == ChangeType.ADD) {
                if (((Set)acc.element).add(change.element)) {
                    return new TaggedElement(acc.element, true);
                }
                return new TaggedElement(acc.element, false);
            }
            if (((Set)acc.element).remove(change.element)) {
                return new TaggedElement(acc.element, true);
            }
            return new TaggedElement(acc.element, false);
        }).filter(tagElt -> (Boolean)tagElt.tag).map(tagElt -> Collections.unmodifiableSet((Set)tagElt.element));
    }

    default public Observable<List<T>> listOnChanged() {
        return this.setOnChanged().map(set -> Collections.unmodifiableList(new ArrayList(set)));
    }

    default public Observable<Optional<T>> firstOnChanged() {
        return this.listOnChanged().map(list -> list.isEmpty() ? Optional.empty() : Optional.of(list.get(0))).distinctUntilChanged();
    }

    default public Snapshot<T> sort(final Comparator<T> comparator) {
        return new Snapshot<T>(){

            @Override
            public Stream<T> unfilteredStream() {
                return Snapshot.this.stream();
            }

            @Override
            public Comparator<T> getComparator() {
                return comparator;
            }

            @Override
            public Observable<T> getAdds() {
                return Snapshot.this.getAdds();
            }

            @Override
            public Observable<T> getRemovals() {
                return Snapshot.this.getRemovals();
            }
        };
    }

    default public Snapshot<T> sorted() {
        Comparator naturalOrder = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                if (o1 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return Collator.getInstance().compare(o1.toString(), o2.toString());
            }
        };
        return this.sort(naturalOrder);
    }

    default public Snapshot<T> filter(final Predicate<T> predicate) {
        return new Snapshot<T>(){
            private Observable<T> adds;
            private Observable<T> removals;
            {
                this.adds = Snapshot.this.getAdds().filter(g -> predicate.test(g)).share();
                this.removals = Snapshot.this.getRemovals().filter(g -> predicate.test(g)).share();
            }

            @Override
            public Stream<T> unfilteredStream() {
                return Snapshot.this.stream().filter(predicate);
            }

            @Override
            public Comparator<T> getComparator() {
                return Snapshot.this.getComparator();
            }

            @Override
            public Observable<T> getAdds() {
                return this.adds;
            }

            @Override
            public Observable<T> getRemovals() {
                return this.removals;
            }

            @Override
            public T get(Object o) {
                Object result = Snapshot.this.get(o);
                return result != null && predicate.test(result) ? (Object)result : null;
            }
        };
    }

    default public Snapshot<T> filter(IndexFilter filter) {
        return Memoizer.getIndexFilterM.apply(this).apply(filter);
    }

    default public Snapshot<T> filter(List<IndexFilter> filters) {
        return Memoizer.getIndexListFilterM.apply(this).apply(filters);
    }

    default public <U> Snapshot<U> map(final Function<T, U> mapper) {
        return new Snapshot<U>(){
            private Observable<U> adds;
            private Observable<U> removals;
            {
                this.adds = Snapshot.this.getAdds().map(mapper).share();
                this.removals = Snapshot.this.getRemovals().map(mapper).share();
            }

            @Override
            public Stream<U> unfilteredStream() {
                return Snapshot.this.stream().map((? super T e) -> {
                    try {
                        return mapper.apply(e);
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException("Exception while handling Snapshot.", ex);
                    }
                });
            }

            @Override
            public Observable<IndexedElement<U>> getIndexedElements() {
                return Snapshot.this.getIndexedElements().map(ie -> new IndexedElement<Object>(mapper.apply(ie.getElement()), ie.getIndex()));
            }

            @Override
            public Observable<U> getAdds() {
                return this.adds;
            }

            @Override
            public Observable<U> getRemovals() {
                return this.removals;
            }
        };
    }

    default public List<T> toList() {
        return this.stream().collect(Collectors.toList());
    }

    default public Set<T> toSet() {
        return this.stream().collect(Collectors.toSet());
    }

    @Deprecated
    default public ObservableList<T> toObservableList() {
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        ObservableList list = FXCollections.observableArrayList(this.toList());
        CompositeDisposable disposables = new CompositeDisposable();
        disposables.add(this.getAdds().subscribe(g -> {
            if (!list.contains(g)) {
                list.add(g);
                logger.debug("Snapshot {}, generic added, {}", (Object)System.identityHashCode(this), g);
            }
        }, e -> logger.error("Exception while computing observable list.", e)));
        disposables.add(this.getRemovals().subscribe(g -> {
            list.remove(g);
            logger.debug("Snapshot {}, generic removed, {}", (Object)System.identityHashCode(this), g);
        }, e -> logger.error("Exception while computing observable list.", e)));
        return list;
    }

    public static class IndexedElement<T> {
        private final int index;
        private final T element;

        public IndexedElement(T element, int index) {
            this.element = element;
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public T getElement() {
            return this.element;
        }

        public int hashCode() {
            return this.element.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IndexedElement)) {
                return false;
            }
            IndexedElement other = (IndexedElement)obj;
            return other.index == this.index && this.element.equals(other.element);
        }
    }

    public static class TaggedElement<T, U> {
        protected final T element;
        protected final U tag;

        public TaggedElement(T element, U tag) {
            this.element = element;
            this.tag = tag;
        }
    }

    public static enum ChangeType {
        ADD,
        REMOVE;

    }
}

