/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.core;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.genericsystem.api.core.AxedPropertyClass;
import org.genericsystem.api.core.IGeneric;
import org.genericsystem.api.core.TagAnnotation;

public class ApiStatics {
    public static final int NO_POSITION = -1;
    public static final int BASE_POSITION = 0;
    public static final int TARGET_POSITION = 1;
    public static final int TERNARY_POSITION = 2;
    public static final int META = 0;
    public static final int STRUCTURAL = 1;
    public static final int CONCRETE = 2;
    public static final int SENSOR = 3;
    public static final int TYPE_SIZE = 0;
    public static final int ATTRIBUTE_SIZE = 1;
    public static final int RELATION_SIZE = 2;
    public static final int TERNARY_RELATION_SIZE = 3;
    public static final long TS_SYSTEM = 0L;
    public static final long TS_OLD_SYSTEM = 1L;
    public static final long[] SYSTEM_TS = new long[]{0L, 0L, Long.MAX_VALUE};
    public static final long[] USER_TS = new long[]{Long.MAX_VALUE, 0L, Long.MAX_VALUE};
    public static final Map<Integer, Class<?>> SUPPORTED_VALUE_CLASSES = new LinkedHashMap<Integer, Class<?>>(){
        {
            this.put(0, AxedPropertyClass.class);
            this.put(1, Boolean.class);
            this.put(2, byte[].class);
            this.put(3, Double.class);
            this.put(4, Float.class);
            this.put(5, Integer.class);
            this.put(6, Long.class);
            this.put(7, Short.class);
            this.put(8, String.class);
            this.put(9, Class.class);
            this.put(10, Class[].class);
            this.put(11, int[].class);
            this.put(12, TagAnnotation.class);
        }
    };

    public static <T extends IGeneric<T>> boolean areOverridesReached(List<T> supers, List<T> overrides) {
        return overrides.stream().allMatch(override -> supers.stream().anyMatch(superVertex -> superVertex.inheritsFrom(override)));
    }
}

