/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.genericsystem.api.core.Snapshot;

public interface IteratorSnapshot<T>
extends Snapshot<T> {
    @Override
    public Iterator<T> iterator();

    @Override
    default public Stream<T> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 0), false);
    }

    @Override
    default public int size() {
        Iterator<T> iterator = this.iterator();
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    @Override
    default public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    default public boolean contains(Object o) {
        return o.equals(this.get(o));
    }

    @Override
    default public boolean containsAll(Collection<?> c) {
        return c.stream().allMatch(this::contains);
    }

    @Override
    public T get(Object var1);

    @Override
    default public String info() {
        return this.stream().collect(Collectors.toList()).toString();
    }

    @Override
    default public T first() {
        Iterator<T> iterator = this.iterator();
        return iterator.hasNext() ? (T)iterator.next() : null;
    }
}

