/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.core;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.json.JsonObject;
import org.genericsystem.api.core.IContext;
import org.genericsystem.api.core.IRoot;
import org.genericsystem.api.core.ISignature;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.core.annotations.constraints.InstanceValueGenerator;

public interface IVertex<T extends IVertex<T>>
extends ISignature<T> {
    public boolean isRoot();

    public IRoot<T> getRoot();

    public boolean isAlive();

    public boolean isSystem();

    public T[] coerceToTArray(Object ... var1);

    public T[] addThisToTargets(T ... var1);

    public T[] addThisToTargets(T var1, T ... var2);

    public int getLevel();

    public boolean isMeta();

    public boolean isStructural();

    public boolean isConcrete();

    public boolean inheritsFrom(T var1);

    public boolean isInstanceOf(T var1);

    public boolean isSpecializationOf(T var1);

    public T getAttribute(Serializable var1, T ... var2);

    public T getAttribute(T ... var1);

    public T getHolder(T var1, Serializable var2, T ... var3);

    public T getRelation(Serializable var1, T ... var2);

    public T getRelation(T ... var1);

    public T getLink(T var1, Serializable var2, T ... var3);

    public T getHolder(T var1, T ... var2);

    public T getLink(T var1, T ... var2);

    public boolean isCompositeOf(T var1);

    public Snapshot<T> getAttributes();

    public Snapshot<T> getAttributes(T ... var1);

    public Snapshot<T> getAttributes(int var1);

    public Snapshot<T> getAttributes(T var1);

    public Snapshot<T> getAttributes(Serializable var1, T ... var2);

    public Snapshot<T> getHolders(T var1);

    public Snapshot<T> getHolders(T var1, int var2);

    public Snapshot<T> getHolders(T var1, Serializable var2, T ... var3);

    public Snapshot<T> getHolders(T var1, T ... var2);

    public Snapshot<T> getRelations(T ... var1);

    public Snapshot<T> getRelations(int var1);

    public Snapshot<T> getRelations(T var1);

    public Snapshot<T> getRelations(Serializable var1, T ... var2);

    public Snapshot<T> getLinks(T var1);

    public Snapshot<T> getLinks(T var1, int var2);

    public Snapshot<T> getLinks(T var1, Serializable var2, T ... var3);

    public Snapshot<T> getLinks(T var1, T ... var2);

    public Serializable getValue(T var1, T ... var2);

    public Snapshot<Serializable> getValues(T var1, T ... var2);

    public Snapshot<Serializable> getValues(T var1, int var2);

    public Serializable getValue(T var1, Serializable var2, T ... var3);

    public Snapshot<Serializable> getValues(T var1, Serializable var2, T ... var3);

    public T getInstance(Serializable var1, T ... var2);

    public T getInstance(T ... var1);

    public T getInstance(T var1, Serializable var2, T ... var3);

    public T getInstance(List<T> var1, Serializable var2, T ... var3);

    public Snapshot<T> getInstances(Serializable var1, T ... var2);

    public Snapshot<T> getInstances();

    public Snapshot<T> getInstances(T ... var1);

    public Snapshot<T> getInstances(T var1, Serializable var2, T ... var3);

    public Snapshot<T> getInstances(List<T> var1, Serializable var2, T ... var3);

    public T getSubInstance(Serializable var1, T ... var2);

    public Snapshot<T> getSubInstances(Serializable var1, T ... var2);

    public T getSubInstance(T ... var1);

    public Snapshot<T> getSubInstances(T ... var1);

    public Snapshot<T> getSubInstances();

    public T getSubInstance(T var1, Serializable var2, T ... var3);

    public Snapshot<T> getSubInstances(T var1, Serializable var2, T ... var3);

    public T getSubInstance(List<T> var1, Serializable var2, T ... var3);

    public Snapshot<T> getSubInstances(List<T> var1, Serializable var2, T ... var3);

    public T getInheriting(Serializable var1, T ... var2);

    public T getInheriting(T ... var1);

    public Snapshot<T> getInheritings(Serializable var1, T ... var2);

    public Snapshot<T> getInheritings(T ... var1);

    public Snapshot<T> getInheritings();

    public T getSubInheriting(Serializable var1, T ... var2);

    public Snapshot<T> getSubInheritings(Serializable var1, T ... var2);

    public T getSubInheriting(T ... var1);

    public Snapshot<T> getSubInheritings(T ... var1);

    public Snapshot<T> getSubInheritings();

    public T getComposite(Serializable var1);

    public Snapshot<T> getComposites(Serializable var1);

    public Snapshot<T> getComposites();

    public boolean isAncestorOf(T var1);

    public String info();

    public String detailedInfo();

    public String toPrettyString();

    public JsonObject toPrettyJSon();

    public Serializable getSystemPropertyValue(Class<? extends SystemProperty> var1, int var2);

    public T setSystemPropertyValue(Class<? extends SystemProperty> var1, int var2, Serializable var3, T ... var4);

    public T enableSystemProperty(Class<? extends SystemProperty> var1, int var2, T ... var3);

    public T disableSystemProperty(Class<? extends SystemProperty> var1, int var2, T ... var3);

    public boolean isSystemPropertyEnabled(Class<? extends SystemProperty> var1, int var2);

    public T enableReferentialIntegrity(int var1);

    public T disableReferentialIntegrity(int var1);

    public boolean isReferentialIntegrityEnabled(int var1);

    public T enableSingularConstraint(int var1);

    public T disableSingularConstraint(int var1);

    public boolean isSingularConstraintEnabled(int var1);

    public T enablePropertyConstraint();

    public T disablePropertyConstraint();

    public boolean isPropertyConstraintEnabled();

    public T enableUniqueValueConstraint();

    public T disableUniqueValueConstraint();

    public boolean isUniqueValueEnabled();

    public Class<? extends Serializable> getInstanceValueClassConstraint();

    public T setInstanceValueClassConstraint(Class<? extends Serializable> var1);

    public Class<? extends InstanceValueGenerator.ValueGenerator> getInstanceValueGenerator();

    public T setInstanceValueGenerator(Class<? extends InstanceValueGenerator.ValueGenerator> var1);

    public T enableRequiredConstraint(int var1);

    public T disableRequiredConstraint(int var1);

    public boolean isRequiredConstraintEnabled(int var1);

    public T enableCascadeRemove(int var1);

    public T disableCascadeRemove(int var1);

    public boolean isCascadeRemoveEnabled(int var1);

    public T enableInheritance();

    public T disableInheritance();

    public boolean isInheritanceEnabled();

    public void remove();

    public T addInstance(Serializable var1, T ... var2);

    public T addInstance(T var1, Serializable var2, T ... var3);

    public T addInstance(List<T> var1, Serializable var2, T ... var3);

    public T setInstance(Serializable var1, T ... var2);

    public T setInstance(T var1, Serializable var2, T ... var3);

    public T setInstance(List<T> var1, Serializable var2, T ... var3);

    public void traverse(Visitor<T> var1);

    public T addAttribute(Serializable var1, T ... var2);

    public T addAttribute(T var1, Serializable var2, T ... var3);

    public T addAttribute(List<T> var1, Serializable var2, T ... var3);

    public T setAttribute(Serializable var1, T ... var2);

    public T setAttribute(T var1, Serializable var2, T ... var3);

    public T setAttribute(List<T> var1, Serializable var2, T ... var3);

    public T addHolder(T var1, Serializable var2, T ... var3);

    public T addHolder(T var1, T var2, Serializable var3, T ... var4);

    public T addHolder(T var1, List<T> var2, Serializable var3, T ... var4);

    public T setHolder(T var1, Serializable var2, T ... var3);

    public T setHolder(T var1, T var2, Serializable var3, T ... var4);

    public T setHolder(T var1, List<T> var2, Serializable var3, T ... var4);

    public T addRelation(Serializable var1, T var2, T ... var3);

    public T addRelation(T var1, Serializable var2, T var3, T ... var4);

    public T addRelation(List<T> var1, Serializable var2, T var3, T ... var4);

    public T setRelation(Serializable var1, T var2, T ... var3);

    public T setRelation(T var1, Serializable var2, T var3, T ... var4);

    public T setRelation(List<T> var1, Serializable var2, T var3, T ... var4);

    public T addLink(T var1, Serializable var2, T var3, T ... var4);

    public T addLink(T var1, T var2, Serializable var3, T var4, T ... var5);

    public T addLink(T var1, List<T> var2, Serializable var3, T var4, T ... var5);

    public T setLink(T var1, Serializable var2, T var3, T ... var4);

    public T setLink(T var1, T var2, Serializable var3, T var4, T ... var5);

    public T setLink(T var1, List<T> var2, Serializable var3, T var4, T ... var5);

    public T updateValue(Serializable var1);

    public T updateSupers(T ... var1);

    public T updateComponents(T ... var1);

    public T update(List<T> var1, Serializable var2, T ... var3);

    public T update(T var1, Serializable var2, T ... var3);

    public T update(Serializable var1, T ... var2);

    public T getBaseComponent();

    public T getTargetComponent();

    public T getTernaryComponent();

    public T getComponent(int var1);

    public IContext<T> getCurrentCache();

    public T getKey(Class<? extends SystemProperty> var1, int var2);

    public static abstract class Visitor<T extends IVertex<T>> {
        private final Set<T> alreadyVisited = new HashSet<T>();

        public void traverse(T node) {
            if (this.alreadyVisited.add(node)) {
                this.before(node);
                for (IVertex child : node.getInheritings()) {
                    this.traverse(child);
                }
                this.after(node);
            }
        }

        public void before(T node) {
        }

        public void after(T node) {
        }
    }

    public static interface SystemProperty {
    }
}

