/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.defaults;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.genericsystem.api.core.IVertex;
import org.genericsystem.api.defaults.DefaultContext;
import org.genericsystem.api.defaults.DefaultVertex;
import org.genericsystem.api.exception.NotFoundException;
import org.genericsystem.kernel.systemproperty.AxedPropertyClass;
import org.genericsystem.kernel.systemproperty.CascadeRemoveProperty;
import org.genericsystem.kernel.systemproperty.NoReferentialIntegrityProperty;
import org.genericsystem.kernel.systemproperty.constraints.InstanceValueClassConstraint;
import org.genericsystem.kernel.systemproperty.constraints.PropertyConstraint;
import org.genericsystem.kernel.systemproperty.constraints.RequiredConstraint;
import org.genericsystem.kernel.systemproperty.constraints.SingularConstraint;
import org.genericsystem.kernel.systemproperty.constraints.UniqueValueConstraint;

public interface DefaultSystemProperties<T extends DefaultVertex<T>>
extends IVertex<T> {
    @Override
    default public Serializable getSystemPropertyValue(Class<? extends IVertex.SystemProperty> propertyClass, int pos) {
        DefaultVertex map = (DefaultVertex)this.getRoot().getMap();
        Stream<DefaultVertex> keys = map != null ? this.getAttributes(map).get() : Stream.empty();
        DefaultVertex key = keys.filter(x -> Objects.equals(x.getValue(), new AxedPropertyClass(propertyClass, pos))).findFirst().orElse(null);
        if (key != null) {
            DefaultVertex result = this.getHolders(key).get().filter(x -> this.isSpecializationOf(x.getBaseComponent())).findFirst().orElse(null);
            return result != null ? result.getValue() : null;
        }
        return null;
    }

    @Override
    default public T setSystemPropertyValue(Class<? extends IVertex.SystemProperty> propertyClass, int pos, Serializable value, T ... targets) {
        DefaultVertex map = (DefaultVertex)this.getRoot().getMap();
        Object[] roots = ((DefaultContext)this.getCurrentCache()).newTArray(targets.length + 1);
        Arrays.fill(roots, this.getRoot());
        ((DefaultVertex)map.getMeta()).setInstance(map, new AxedPropertyClass(propertyClass, pos), (DefaultVertex[])roots).setInstance(value, (DefaultVertex[])this.addThisToTargets((IVertex[])targets));
        return (T)((DefaultVertex)this);
    }

    @Override
    default public T enableSystemProperty(Class<? extends IVertex.SystemProperty> propertyClass, int pos, T ... targets) {
        if (pos != -1 && this.getComponent(pos) == null) {
            ((DefaultContext)this.getCurrentCache()).discardWithException(new NotFoundException("System property is not apply because no component exists for position : " + pos));
        }
        this.setSystemPropertyValue(propertyClass, pos, Boolean.TRUE, (DefaultVertex[])targets);
        return (T)((DefaultVertex)this);
    }

    @Override
    default public T disableSystemProperty(Class<? extends IVertex.SystemProperty> propertyClass, int pos, T ... targets) {
        this.setSystemPropertyValue(propertyClass, pos, Boolean.FALSE, (DefaultVertex[])targets);
        return (T)((DefaultVertex)this);
    }

    @Override
    default public boolean isSystemPropertyEnabled(Class<? extends IVertex.SystemProperty> propertyClass, int pos) {
        Serializable value = this.getSystemPropertyValue(propertyClass, pos);
        return value != null && !Boolean.FALSE.equals(value);
    }

    @Override
    default public T enableReferentialIntegrity(int pos) {
        return (T)this.disableSystemProperty(NoReferentialIntegrityProperty.class, pos, new DefaultVertex[0]);
    }

    @Override
    default public T disableReferentialIntegrity(int pos) {
        return (T)this.enableSystemProperty(NoReferentialIntegrityProperty.class, pos, new DefaultVertex[0]);
    }

    @Override
    default public boolean isReferentialIntegrityEnabled(int pos) {
        return !this.isSystemPropertyEnabled(NoReferentialIntegrityProperty.class, pos);
    }

    @Override
    default public T enableSingularConstraint(int pos) {
        return (T)this.enableSystemProperty(SingularConstraint.class, pos, new DefaultVertex[0]);
    }

    @Override
    default public T disableSingularConstraint(int pos) {
        return (T)this.disableSystemProperty(SingularConstraint.class, pos, new DefaultVertex[0]);
    }

    @Override
    default public boolean isSingularConstraintEnabled(int pos) {
        return this.isSystemPropertyEnabled(SingularConstraint.class, pos);
    }

    @Override
    default public T enablePropertyConstraint() {
        return (T)this.enableSystemProperty(PropertyConstraint.class, -1, new DefaultVertex[0]);
    }

    @Override
    default public T disablePropertyConstraint() {
        return (T)this.disableSystemProperty(PropertyConstraint.class, -1, new DefaultVertex[0]);
    }

    @Override
    default public boolean isPropertyConstraintEnabled() {
        return this.isSystemPropertyEnabled(PropertyConstraint.class, -1);
    }

    @Override
    default public T enableUniqueValueConstraint() {
        return (T)this.enableSystemProperty(UniqueValueConstraint.class, -1, new DefaultVertex[0]);
    }

    @Override
    default public T disableUniqueValueConstraint() {
        return (T)this.disableSystemProperty(UniqueValueConstraint.class, -1, new DefaultVertex[0]);
    }

    @Override
    default public boolean isUniqueValueEnabled() {
        return this.isSystemPropertyEnabled(UniqueValueConstraint.class, -1);
    }

    @Override
    default public Class<?> getClassConstraint() {
        return (Class)this.getSystemPropertyValue(InstanceValueClassConstraint.class, -1);
    }

    @Override
    default public T setClassConstraint(Class<?> constraintClass) {
        this.setSystemPropertyValue(InstanceValueClassConstraint.class, -1, constraintClass, new DefaultVertex[0]);
        return (T)((DefaultVertex)this);
    }

    @Override
    default public T enableClassConstraint(Class<?> constraintClass) {
        return (T)this.setClassConstraint((Class)constraintClass);
    }

    @Override
    default public T disableClassConstraint() {
        return (T)this.setClassConstraint((Class)null);
    }

    @Override
    default public T enableRequiredConstraint(int pos) {
        return (T)this.enableSystemProperty(RequiredConstraint.class, pos, (DefaultVertex[])this.coerceToTArray(new Object[]{this.getComponents().get(pos)}));
    }

    @Override
    default public T disableRequiredConstraint(int pos) {
        return (T)this.disableSystemProperty(RequiredConstraint.class, pos, (DefaultVertex[])this.coerceToTArray(new Object[]{this.getComponents().get(pos)}));
    }

    @Override
    default public boolean isRequiredConstraintEnabled(int pos) {
        return this.isSystemPropertyEnabled(RequiredConstraint.class, pos);
    }

    @Override
    default public T enableCascadeRemove(int pos) {
        return (T)this.enableSystemProperty(CascadeRemoveProperty.class, pos, new DefaultVertex[0]);
    }

    @Override
    default public T disableCascadeRemove(int pos) {
        return (T)this.disableSystemProperty(CascadeRemoveProperty.class, pos, new DefaultVertex[0]);
    }

    @Override
    default public boolean isCascadeRemoveEnabled(int pos) {
        return this.isSystemPropertyEnabled(CascadeRemoveProperty.class, pos);
    }
}

