/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.defaults;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.genericsystem.api.core.IVertex;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.defaults.DefaultContext;
import org.genericsystem.api.defaults.DefaultVertex;
import org.genericsystem.api.exception.AmbiguousSelectionException;

public interface DefaultDependencies<T extends DefaultVertex<T>>
extends IVertex<T> {
    @Override
    default public boolean isAlive() {
        return this.getCurrentCache().isAlive((DefaultVertex)this);
    }

    @Override
    default public boolean isAncestorOf(T dependency) {
        return this.equals(dependency) || !dependency.isMeta() && this.isAncestorOf((T)((DefaultVertex)dependency.getMeta())) || dependency.getSupers().stream().anyMatch(this::isAncestorOf) || dependency.getComponents().stream().filter(x -> x != null).anyMatch(this::isAncestorOf);
    }

    @Override
    default public DefaultContext<T> getCurrentCache() {
        return (DefaultContext)this.getRoot().getCurrentCache();
    }

    @Override
    default public T getInstance(List<T> overrides, Serializable value, T ... components) {
        return (T)this.getCurrentCache().getInstance((DefaultVertex)this, overrides, value, (DefaultVertex[])components);
    }

    @Override
    default public Snapshot<T> getInstances() {
        return this.getCurrentCache().getInstances((DefaultVertex)this);
    }

    @Override
    default public Snapshot<T> getInheritings() {
        return this.getCurrentCache().getInheritings((DefaultVertex)this);
    }

    @Override
    default public Snapshot<T> getComposites() {
        return this.getCurrentCache().getComposites((DefaultVertex)this);
    }

    @Override
    default public Snapshot<T> getAllInheritings() {
        return () -> Stream.concat(Stream.of((DefaultVertex)this), this.getInheritings().get().flatMap(inheriting -> inheriting.getAllInheritings().get())).distinct();
    }

    @Override
    default public Snapshot<T> getAllInstances() {
        return () -> this.getAllInheritings().get().flatMap(inheriting -> inheriting.getInstances().get());
    }

    @Override
    default public T getInstance(T superT, Serializable value, T ... components) {
        return (T)this.getInstance(Collections.singletonList(superT), value, (DefaultVertex[])components);
    }

    @Override
    default public T getInstance(Serializable value, T ... components) {
        return (T)this.getInstance(Collections.emptyList(), value, (DefaultVertex[])components);
    }

    public static <T extends DefaultVertex<T>> Predicate<T> valueFilter(Serializable value) {
        return attribute -> Objects.equals(attribute.getValue(), value);
    }

    default public Predicate<T> componentsFilter(T ... components) {
        return attribute -> {
            ArrayList attributeComps = new ArrayList(attribute.getComponents());
            for (DefaultVertex component : components) {
                DefaultVertex matchedComponent = attributeComps.stream().filter(attributeComponent -> attributeComponent.isSpecializationOf(component)).findFirst().orElse(null);
                if (matchedComponent == null) {
                    return false;
                }
                attributeComps.remove(matchedComponent);
            }
            return true;
        };
    }

    @Override
    default public T getAttribute(Serializable value, T ... targets) {
        return this.getNonAmbiguousResult(this.getAttributes().get().filter(DefaultDependencies.valueFilter(value)).filter(this.componentsFilter((DefaultVertex[])targets)));
    }

    @Override
    default public T getHolder(T attribute, Serializable value, T ... targets) {
        return this.getNonAmbiguousResult(this.getHolders(attribute).get().filter(DefaultDependencies.valueFilter(value)).filter(this.componentsFilter((DefaultVertex[])targets)));
    }

    @Override
    default public T getRelation(Serializable value, T ... targets) {
        return this.getNonAmbiguousResult(this.getRelations().get().filter(DefaultDependencies.valueFilter(value)).filter(this.componentsFilter((DefaultVertex[])targets)));
    }

    @Override
    default public T getLink(T relation, Serializable value, T ... targets) {
        return this.getNonAmbiguousResult(this.getLinks(relation).get().filter(DefaultDependencies.valueFilter(value)).filter(this.componentsFilter((DefaultVertex[])targets)));
    }

    @Override
    default public T getHolder(T attribute, T ... targets) {
        return this.getNonAmbiguousResult(this.getHolders(attribute).get().filter(this.componentsFilter((DefaultVertex[])targets)));
    }

    @Override
    default public T getLink(T relation, T ... targets) {
        return this.getNonAmbiguousResult(this.getLinks(relation).get().filter(this.componentsFilter((DefaultVertex[])targets)));
    }

    default public T getNonAmbiguousResult(Stream<T> stream) {
        Iterator iterator = stream.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        DefaultVertex result = (DefaultVertex)iterator.next();
        if (iterator.hasNext()) {
            this.getCurrentCache().discardWithException(new AmbiguousSelectionException(result.info() + " " + ((DefaultVertex)iterator.next()).info()));
        }
        return (T)result;
    }
}

