/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.defaults;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.genericsystem.api.core.IContext;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.defaults.DefaultRoot;
import org.genericsystem.api.defaults.DefaultVertex;
import org.genericsystem.api.exception.ReferentialIntegrityConstraintViolationException;
import org.genericsystem.api.exception.RollbackException;

public interface DefaultContext<T extends DefaultVertex<T>>
extends IContext<T> {
    public DefaultRoot<T> getRoot();

    default public boolean isAlive(T vertex) {
        class AliveFinder {
            AliveFinder() {
            }

            T find(T vertex) {
                if (vertex.isRoot()) {
                    return vertex;
                }
                if (vertex.isMeta()) {
                    Object aliveSuper = new AliveFinder().find((DefaultVertex)vertex.getSupers().get(0));
                    return aliveSuper != null ? (DefaultVertex)DefaultContext.this.getInheritings(aliveSuper).get(vertex) : null;
                }
                Object aliveMeta = new AliveFinder().find((DefaultVertex)vertex.getMeta());
                return aliveMeta != null ? (DefaultVertex)DefaultContext.this.getInstances(aliveMeta).get(vertex) : null;
            }
        }
        return vertex != null && vertex.equals(new AliveFinder().find(vertex));
    }

    default public T getInstance(T meta, List<T> overrides, Serializable value, T ... components) {
        List<T> componentsList = Arrays.asList(components);
        T adjustMeta = meta.adjustMeta(value, componentsList);
        if (adjustMeta.getComponents().size() < components.length) {
            return null;
        }
        return adjustMeta.getDirectInstance(overrides, value, componentsList);
    }

    default public Snapshot<T> getInstances(T vertex) {
        return this.getDependencies(vertex).filter(x -> vertex.equals(x.getMeta()));
    }

    default public Snapshot<T> getInheritings(T vertex) {
        return this.getDependencies(vertex).filter(x -> x.getSupers().contains(vertex));
    }

    default public Snapshot<T> getComposites(T vertex) {
        return this.getDependencies(vertex).filter(x -> x.getComponents().contains(vertex));
    }

    default public void discardWithException(Throwable exception) throws RollbackException {
        throw new RollbackException(exception);
    }

    public T[] newTArray(int var1);

    public T addInstance(T var1, List<T> var2, Serializable var3, List<T> var4);

    public T update(T var1, List<T> var2, Serializable var3, List<T> var4);

    public T setInstance(T var1, List<T> var2, Serializable var3, List<T> var4);

    public void forceRemove(T var1);

    public void remove(T var1);

    public void conserveRemove(T var1);

    default public NavigableSet<T> computeDependencies(T node) {
        class OrderedDependencies
        extends TreeSet<T> {
            private static final long serialVersionUID = -441180182522681264L;

            OrderedDependencies() {
            }

            org.genericsystem.api.defaults.DefaultContext.1OrderedDependencies visit(T node) {
                if (!this.contains(node)) {
                    this.add(node);
                    DefaultContext.this.getDependencies(node).forEach((Consumer<DefaultVertex>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, visit(org.genericsystem.api.defaults.DefaultVertex ), (Lorg/genericsystem/api/defaults/DefaultVertex;)V)((OrderedDependencies)this));
                }
                return this;
            }
        }
        return new OrderedDependencies().visit((DefaultVertex)node);
    }

    default public NavigableSet<T> computePotentialDependencies(T meta, List<T> supers, Serializable value, List<T> components) {
        class PotentialDependenciesComputer
        extends TreeSet<T> {
            private static final long serialVersionUID = -4464199068092100672L;
            private final Set<T> alreadyVisited = new HashSet();
            final /* synthetic */ DefaultVertex val$meta;
            final /* synthetic */ List val$supers;
            final /* synthetic */ Serializable val$value;
            final /* synthetic */ List val$components;

            PotentialDependenciesComputer() {
                this.val$meta = defaultVertex;
                this.val$supers = list;
                this.val$value = serializable;
                this.val$components = list2;
            }

            org.genericsystem.api.defaults.DefaultContext.1PotentialDependenciesComputer visit(T node) {
                if (!this.alreadyVisited.contains(node)) {
                    if (node.isDependencyOf((DefaultVertex)this.val$meta, this.val$supers, this.val$value, this.val$components)) {
                        super.addAll(DefaultContext.this.computeDependencies(node));
                    } else {
                        this.alreadyVisited.add(node);
                        DefaultContext.this.getDependencies(node).forEach((Consumer<DefaultVertex>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, visit(org.genericsystem.api.defaults.DefaultVertex ), (Lorg/genericsystem/api/defaults/DefaultVertex;)V)((PotentialDependenciesComputer)this));
                    }
                }
                return this;
            }
        }
        return new PotentialDependenciesComputer().visit((DefaultVertex)meta);
    }

    default public NavigableSet<T> computeRemoveDependencies(T node) {
        class OrderedRemoveDependencies
        extends TreeSet<T> {
            private static final long serialVersionUID = -5970021419012502402L;

            OrderedRemoveDependencies() {
            }

            org.genericsystem.api.defaults.DefaultContext.1OrderedRemoveDependencies visit(T node) {
                if (!this.contains(node)) {
                    if (!DefaultContext.this.getInheritings(node).isEmpty()) {
                        DefaultContext.this.discardWithException(new ReferentialIntegrityConstraintViolationException("Ancestor : " + node + " has a inheriting dependencies : " + DefaultContext.this.getInheritings(node).info()));
                    }
                    DefaultContext.this.getInheritings(node).forEach((Consumer<DefaultVertex>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, visit(org.genericsystem.api.defaults.DefaultVertex ), (Lorg/genericsystem/api/defaults/DefaultVertex;)V)((OrderedRemoveDependencies)this));
                    if (!DefaultContext.this.getInstances(node).isEmpty()) {
                        DefaultContext.this.discardWithException(new ReferentialIntegrityConstraintViolationException("Ancestor : " + node + " has a instance dependencies : " + DefaultContext.this.getInstances(node).info()));
                    }
                    DefaultContext.this.getInstances(node).forEach((Consumer<DefaultVertex>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, visit(org.genericsystem.api.defaults.DefaultVertex ), (Lorg/genericsystem/api/defaults/DefaultVertex;)V)((OrderedRemoveDependencies)this));
                    for (DefaultVertex composite : DefaultContext.this.getComposites(node)) {
                        for (int componentPos = 0; componentPos < composite.getComponents().size(); ++componentPos) {
                            if (!((DefaultVertex)composite.getComponents().get(componentPos)).equals(node) || this.contains(composite) || !((DefaultVertex)composite.getMeta()).isReferentialIntegrityEnabled(componentPos)) continue;
                            DefaultContext.this.discardWithException(new ReferentialIntegrityConstraintViolationException(composite + " is Referential Integrity for ancestor " + node + " by composite position : " + componentPos));
                        }
                        this.visit(composite);
                    }
                    this.add(node);
                    for (int axe = 0; axe < node.getComponents().size(); ++axe) {
                        if (!node.isCascadeRemoveEnabled(axe)) continue;
                        this.visit((DefaultVertex)node.getComponents().get(axe));
                    }
                }
                return this;
            }
        }
        return new OrderedRemoveDependencies().visit((DefaultVertex)node);
    }

    public Snapshot<T> getDependencies(T var1);
}

