/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.defaults;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.genericsystem.api.core.IVertex;
import org.genericsystem.api.defaults.DefaultContext;
import org.genericsystem.api.defaults.DefaultVertex;

public interface DefaultWritable<T extends DefaultVertex<T>>
extends IVertex<T> {
    @Override
    default public T updateValue(Serializable newValue) {
        return (T)((DefaultVertex)this.update(this.getSupers(), newValue, this.coerceToTArray(this.getComponents().toArray())));
    }

    @Override
    default public T updateSupers(T ... supers) {
        return (T)((DefaultVertex)this.update(Arrays.asList(supers), this.getValue(), this.coerceToTArray(this.getComponents().toArray())));
    }

    @Override
    default public T updateComponents(T ... newComposites) {
        return (T)((DefaultVertex)this.update(this.getSupers(), this.getValue(), (IVertex[])newComposites));
    }

    @Override
    default public T update(Serializable newValue, T ... newComposites) {
        return (T)((DefaultVertex)this.update(Collections.emptyList(), newValue, (IVertex[])newComposites));
    }

    @Override
    default public T update(T override, Serializable newValue, T ... newComposites) {
        return (T)((DefaultVertex)this.update(Collections.singletonList(override), newValue, (IVertex[])newComposites));
    }

    @Override
    default public T setInstance(Serializable value, T ... components) {
        return (T)((DefaultVertex)this.setInstance(Collections.emptyList(), value, (IVertex[])components));
    }

    @Override
    default public T setInstance(T override, Serializable value, T ... components) {
        return (T)((DefaultVertex)this.setInstance(Collections.singletonList(override), value, (IVertex[])components));
    }

    @Override
    default public T addInstance(Serializable value, T ... components) {
        return (T)((DefaultVertex)this.addInstance(Collections.emptyList(), value, (IVertex[])components));
    }

    @Override
    default public T addInstance(T override, Serializable value, T ... components) {
        return (T)((DefaultVertex)this.addInstance(Collections.singletonList(override), value, (IVertex[])components));
    }

    @Override
    default public T addAttribute(Serializable value, T ... targets) {
        return (T)this.addAttribute(Collections.emptyList(), value, (DefaultVertex[])targets);
    }

    @Override
    default public T setAttribute(Serializable value, T ... targets) {
        return (T)this.setAttribute(Collections.emptyList(), value, (DefaultVertex[])targets);
    }

    @Override
    default public T addRelation(Serializable value, T firstTarget, T ... otherTargets) {
        return (T)this.addRelation(Collections.emptyList(), value, (DefaultVertex)firstTarget, (DefaultVertex[])otherTargets);
    }

    @Override
    default public T setRelation(Serializable value, T firstTarget, T ... otherTargets) {
        return (T)this.setRelation(Collections.emptyList(), value, (DefaultVertex)firstTarget, (DefaultVertex[])otherTargets);
    }

    @Override
    default public T addHolder(T attribute, Serializable value, T ... targets) {
        return (T)attribute.addInstance(value, this.addThisToTargets((DefaultVertex[])targets));
    }

    @Override
    default public T setHolder(T attribute, Serializable value, T ... targets) {
        return (T)attribute.setInstance(value, this.addThisToTargets((DefaultVertex[])targets));
    }

    @Override
    default public T addLink(T relation, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)relation.addInstance(value, this.addThisToTargets((DefaultVertex)firstTarget, (DefaultVertex[])otherTargets));
    }

    @Override
    default public T setLink(T relation, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)relation.setInstance(value, this.addThisToTargets((DefaultVertex)firstTarget, (DefaultVertex[])otherTargets));
    }

    @Override
    default public T addAttribute(T override, Serializable value, T ... targets) {
        return (T)this.addAttribute(Collections.singletonList(override), value, (DefaultVertex[])targets);
    }

    @Override
    default public T setAttribute(T override, Serializable value, T ... targets) {
        return (T)this.setAttribute(Collections.singletonList(override), value, (DefaultVertex[])targets);
    }

    @Override
    default public T addRelation(T override, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)this.addRelation(Collections.singletonList(override), value, (DefaultVertex)firstTarget, (DefaultVertex[])otherTargets);
    }

    @Override
    default public T setRelation(T override, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)this.setRelation(Collections.singletonList(override), value, (DefaultVertex)firstTarget, (DefaultVertex[])otherTargets);
    }

    @Override
    default public T addHolder(T attribute, T override, Serializable value, T ... targets) {
        return (T)attribute.addInstance(override, value, this.addThisToTargets((DefaultVertex[])targets));
    }

    @Override
    default public T setHolder(T attribute, T override, Serializable value, T ... targets) {
        return (T)attribute.setInstance(override, value, this.addThisToTargets((DefaultVertex[])targets));
    }

    @Override
    default public T addLink(T relation, T override, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)relation.addInstance(override, value, this.addThisToTargets((DefaultVertex)firstTarget, (DefaultVertex[])otherTargets));
    }

    @Override
    default public T setLink(T relation, T override, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)relation.setInstance(override, value, this.addThisToTargets((DefaultVertex)firstTarget, (DefaultVertex[])otherTargets));
    }

    @Override
    default public T addAttribute(List<T> overrides, Serializable value, T ... targets) {
        return (T)((DefaultVertex)this.getRoot().addInstance(overrides, value, this.addThisToTargets((DefaultVertex[])targets)));
    }

    @Override
    default public T setAttribute(List<T> overrides, Serializable value, T ... targets) {
        return (T)((DefaultVertex)this.getRoot().setInstance(overrides, value, this.addThisToTargets((DefaultVertex[])targets)));
    }

    @Override
    default public T addRelation(List<T> overrides, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)((DefaultVertex)this.getRoot().addInstance(overrides, value, this.addThisToTargets((DefaultVertex)firstTarget, (DefaultVertex[])otherTargets)));
    }

    @Override
    default public T setRelation(List<T> overrides, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)((DefaultVertex)this.getRoot().setInstance(overrides, value, this.addThisToTargets((DefaultVertex)firstTarget, (DefaultVertex[])otherTargets)));
    }

    @Override
    default public T addHolder(T attribute, List<T> overrides, Serializable value, T ... targets) {
        return (T)attribute.addInstance(overrides, value, this.addThisToTargets((DefaultVertex[])targets));
    }

    @Override
    default public T setHolder(T attribute, List<T> overrides, Serializable value, T ... targets) {
        return (T)attribute.setInstance(overrides, value, this.addThisToTargets((DefaultVertex[])targets));
    }

    @Override
    default public T addLink(T relation, List<T> overrides, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)relation.addInstance(overrides, value, this.addThisToTargets((DefaultVertex)firstTarget, (DefaultVertex[])otherTargets));
    }

    @Override
    default public T setLink(T relation, List<T> overrides, Serializable value, T firstTarget, T ... otherTargets) {
        return (T)relation.setInstance(overrides, value, this.addThisToTargets((DefaultVertex)firstTarget, (DefaultVertex[])otherTargets));
    }

    @Override
    default public DefaultContext<T> getCurrentCache() {
        return (DefaultContext)this.getRoot().getCurrentCache();
    }

    @Override
    default public T[] addThisToTargets(T ... targets) {
        DefaultVertex[] composites = this.getCurrentCache().getBuilder().newTArray(targets.length + 1);
        composites[0] = (DefaultVertex)this;
        System.arraycopy(targets, 0, composites, 1, targets.length);
        return composites;
    }

    @Override
    default public T[] addThisToTargets(T firstTarget, T ... otherTargets) {
        return this.addThisToTargets(firstTarget.addThisToTargets(otherTargets));
    }

    default public void forceRemove() {
        this.getCurrentCache().getBuilder().forceRemove((DefaultVertex)this);
    }

    default public void conserveRemove() {
        this.getCurrentCache().getBuilder().conserveRemove((DefaultVertex)this);
    }

    @Override
    default public void remove() {
        this.getCurrentCache().getBuilder().remove((DefaultVertex)this);
    }
}

