/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.defaults;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.genericsystem.api.core.ApiStatics;
import org.genericsystem.api.defaults.DefaultAncestors;
import org.genericsystem.api.defaults.DefaultCompositesInheritance;
import org.genericsystem.api.defaults.DefaultContext;
import org.genericsystem.api.defaults.DefaultDependencies;
import org.genericsystem.api.defaults.DefaultDisplay;
import org.genericsystem.api.defaults.DefaultSystemProperties;
import org.genericsystem.api.defaults.DefaultTree;
import org.genericsystem.api.defaults.DefaultWritable;

public interface DefaultVertex<T extends DefaultVertex<T>>
extends DefaultAncestors<T>,
DefaultDependencies<T>,
DefaultDisplay<T>,
DefaultSystemProperties<T>,
DefaultCompositesInheritance<T>,
DefaultWritable<T>,
DefaultTree<T> {
    @Override
    default public DefaultContext<T> getCurrentCache() {
        return (DefaultContext)this.getRoot().getCurrentCache();
    }

    @Override
    default public T addInstance(List<T> overrides, Serializable value, T ... components) {
        return (T)this.getCurrentCache().getBuilder().addInstance(null, this, overrides, value, Arrays.asList(components));
    }

    @Override
    default public T setInstance(List<T> overrides, Serializable value, T ... components) {
        return (T)this.getCurrentCache().getBuilder().setInstance(null, this, overrides, value, Arrays.asList(components));
    }

    @Override
    default public T update(List<T> overrides, Serializable newValue, T ... newComponents) {
        return (T)this.getCurrentCache().getBuilder().update(this, overrides, newValue, Arrays.asList(newComponents));
    }

    public static <T extends DefaultVertex<T>> boolean isSuperOf(T subMeta, Serializable subValue, List<T> subComponents, T superMeta, Serializable superValue, List<T> superComponents) {
        if (subMeta == null ? !superMeta.isMeta() : !subMeta.inheritsFrom(superMeta)) {
            return false;
        }
        boolean[] singular = new boolean[1];
        if (!superMeta.componentsDepends(subComponents, superComponents, singular)) {
            return false;
        }
        if (singular[0]) {
            return true;
        }
        if (superMeta.isPropertyConstraintEnabled() && !subComponents.equals(superComponents)) {
            return true;
        }
        return Objects.equals(subValue, superValue);
    }

    default public boolean inheritsFrom(T superMeta, Serializable superValue, List<T> superComponents) {
        return DefaultVertex.isSuperOf((DefaultVertex)this.getMeta(), this.getValue(), this.getComponents(), superMeta, superValue, superComponents);
    }

    default public boolean isDependencyOf(T meta, List<T> supers, Serializable value, List<T> components) {
        return this.inheritsFrom(meta, value, components) || this.getComponents().stream().filter(component -> component != null).anyMatch(component -> component.isDependencyOf(meta, supers, value, components)) || !this.isMeta() && ((DefaultVertex)this.getMeta()).isDependencyOf(meta, supers, value, components) || !components.equals(this.getComponents()) && this.componentsDepends(this.getComponents(), components) && supers.stream().anyMatch(override -> override.inheritsFrom((DefaultVertex)this.getMeta()));
    }

    default public boolean isSuperOf(T subMeta, List<T> overrides, Serializable subValue, List<T> subComponents) {
        return overrides.stream().anyMatch(override -> override.inheritsFrom(this)) || ApiStatics.areOverridesReached(this.getSupers(), overrides) && DefaultVertex.isSuperOf(subMeta, subValue, subComponents, (DefaultVertex)this.getMeta(), this.getValue(), this.getComponents());
    }

    default public boolean componentsDepends(List<T> subComponents, List<T> superComponents) {
        return this.componentsDepends(subComponents, superComponents, new boolean[1]);
    }

    default public boolean componentsDepends(List<T> subComponents, List<T> superComponents, boolean[] singular) {
        singular[0] = false;
        int subIndex = 0;
        block0: for (DefaultVertex superComponent : superComponents) {
            while (subIndex < subComponents.size()) {
                DefaultVertex subComponent = (DefaultVertex)subComponents.get(subIndex);
                if (subComponent == null && superComponent == null || subComponent != null && superComponent != null && subComponent.isSpecializationOf(superComponent) || subComponent == null && superComponent != null && this.isSpecializationOf(superComponent) || subComponent != null && superComponent == null && subComponent.isSpecializationOf(this)) {
                    if (this.isSingularConstraintEnabled(subIndex) && subComponent != superComponent) {
                        singular[0] = true;
                    }
                    ++subIndex;
                    continue block0;
                }
                ++subIndex;
            }
            return singular[0];
        }
        return true;
    }

    @Override
    default public T[] coerceToTArray(Object ... array) {
        DefaultVertex[] result = this.getCurrentCache().getBuilder().newTArray(array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = (DefaultVertex)array[i];
        }
        return result;
    }
}

