/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.defaults;

import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Stream;
import org.genericsystem.api.core.IVertex;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.defaults.DefaultVertex;

public interface DefaultTree<T extends DefaultVertex<T>>
extends IVertex<T> {
    @Override
    default public T addRoot(Serializable value) {
        return (T)((DefaultVertex)this.addInstance(value, this.coerceToTArray(new Object[((DefaultVertex)this.getMeta()).getComponents().size()])));
    }

    @Override
    default public T setRoot(Serializable value) {
        return (T)((DefaultVertex)this.setInstance(value, this.coerceToTArray(new Object[((DefaultVertex)this.getMeta()).getComponents().size()])));
    }

    @Override
    default public T addChild(Serializable value, T ... targets) {
        return (T)((DefaultVertex)this.addHolder((IVertex)this.getMeta(), value, (IVertex[])targets));
    }

    @Override
    default public T setChild(Serializable value, T ... targets) {
        return (T)((DefaultVertex)this.setHolder((IVertex)this.getMeta(), value, (IVertex[])targets));
    }

    @Override
    default public T addInheritingChild(Serializable value, T ... targets) {
        return (T)((DefaultVertex)this.addHolder((IVertex)this.getMeta(), Arrays.asList(this.addThisToTargets((IVertex[])targets)), value, (IVertex[])targets));
    }

    @Override
    default public T setInheritingChild(Serializable value, T ... targets) {
        return (T)((DefaultVertex)this.setHolder((IVertex)this.getMeta(), Arrays.asList(this.addThisToTargets((IVertex[])targets)), value, (IVertex[])targets));
    }

    @Override
    default public Snapshot<T> getChildren() {
        return () -> this.getComposites().get().filter(x -> ((DefaultVertex)x.getMeta()).equals(this.getMeta()));
    }

    @Override
    default public Snapshot<T> getAllChildren() {
        return () -> Stream.concat(Stream.of((DefaultVertex)this), this.getChildren().get().flatMap(node -> node.getAllChildren().get())).distinct();
    }

    @Override
    default public void traverse(IVertex.Visitor<T> visitor) {
        visitor.traverse((DefaultVertex)this);
    }
}

