/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.defaults;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import org.genericsystem.api.core.IVertex;
import org.genericsystem.api.defaults.DefaultVertex;

public interface DefaultDisplay<T extends DefaultVertex<T>>
extends IVertex<T> {
    @Override
    default public String info() {
        return "(" + ((DefaultVertex)this.getMeta()).getValue() + ")" + this.getSupers() + this + this.getComponents() + " ";
    }

    @Override
    default public String detailedInfo() {
        String s = "\n\n*******************************" + System.identityHashCode(this) + "******************************\n";
        s = s + " Value       : " + this.getValue() + "\n";
        s = s + " Meta        : " + this.getMeta() + " (" + System.identityHashCode(this.getMeta()) + ")\n";
        s = s + " MetaLevel   : " + DefaultDisplay.getMetaLevelString(this.getLevel()) + "\n";
        s = s + " Category    : " + DefaultDisplay.getCategoryString(this.getLevel(), this.getComponents().size()) + "\n";
        s = s + " Class       : " + this.getClass().getName() + "\n";
        s = s + "**********************************************************************\n";
        for (DefaultVertex superGeneric : this.getSupers()) {
            s = s + " Super       : " + superGeneric + " (" + System.identityHashCode(superGeneric) + ")\n";
        }
        for (DefaultVertex component : this.getComponents()) {
            s = s + " Component   : " + component + " (" + System.identityHashCode(component) + ")\n";
        }
        s = s + "**********************************************************************\n";
        return s;
    }

    @Override
    default public String toPrettyString() {
        StringWriter writer = new StringWriter();
        JsonWriter jsonWriter = Json.createWriterFactory((Map)new HashMap<String, JsonValue>(){
            private static final long serialVersionUID = -8719498570554805477L;
            {
                this.put("javax.json.stream.JsonGenerator.prettyPrinting", JsonValue.TRUE);
            }
        }).createWriter((Writer)writer);
        jsonWriter.write((JsonStructure)this.toPrettyJSon());
        jsonWriter.close();
        return writer.toString();
    }

    @Override
    default public JsonObject toPrettyJSon() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("Value", this.toString());
        for (DefaultVertex attribute : this.getAttributes()) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (DefaultVertex holder : this.getHolders(attribute)) {
                if (((DefaultVertex)holder.getComponents().get(0)).isSpecializationOf((DefaultVertex)this)) {
                    arrayBuilder.add((JsonValue)holder.toPrettyJSon());
                }
                builder.add(attribute.toString(), arrayBuilder);
            }
        }
        return builder.build();
    }

    @Override
    default public JsonObject toJSonId() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("Id", System.identityHashCode(this));
        builder.add("Value", this.toString());
        builder.add("Meta", System.identityHashCode(this.getMeta()));
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (DefaultVertex superVertex : this.getSupers()) {
            arrayBuilder.add(System.identityHashCode(superVertex));
        }
        builder.add("Supers", arrayBuilder);
        for (DefaultVertex composite : this.getComponents()) {
            arrayBuilder.add(System.identityHashCode(composite));
        }
        builder.add("Composites", arrayBuilder);
        return builder.build();
    }

    public static String getMetaLevelString(int metaLevel) {
        switch (metaLevel) {
            case 0: {
                return "META";
            }
            case 1: {
                return "STRUCTURAL";
            }
            case 2: {
                return "CONCRETE";
            }
            case 3: {
                return "SENSOR";
            }
        }
        return "UNKNOWN";
    }

    public static String getCategoryString(int metaLevel, int dim) {
        switch (metaLevel) {
            case 0: {
                switch (dim) {
                    case 0: {
                        return "MetaType";
                    }
                    case 1: {
                        return "MetaAttribute";
                    }
                    case 2: {
                        return "MetaRelation";
                    }
                }
                return "MetaNRelation";
            }
            case 1: {
                switch (dim) {
                    case 0: {
                        return "Type";
                    }
                    case 1: {
                        return "Attribute";
                    }
                    case 2: {
                        return "Relation";
                    }
                }
                return "NRelation";
            }
            case 2: {
                switch (dim) {
                    case 0: {
                        return "Instance";
                    }
                    case 1: {
                        return "Holder";
                    }
                    case 2: {
                        return "Link";
                    }
                }
                return "NLink";
            }
        }
        return null;
    }
}

