/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.defaults;

import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.genericsystem.api.core.IVertex;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.api.defaults.DefaultContext;
import org.genericsystem.api.defaults.DefaultVertex;

public interface DefaultDependencies<T extends DefaultVertex<T>>
extends IVertex<T> {
    @Override
    default public boolean isAlive() {
        return this.getCurrentCache().isAlive((DefaultVertex)this);
    }

    @Override
    default public boolean isAncestorOf(T dependency) {
        return this.equals(dependency) || !dependency.isMeta() && this.isAncestorOf((T)((DefaultVertex)dependency.getMeta())) || dependency.getSupers().stream().anyMatch(this::isAncestorOf) || dependency.getComponents().stream().filter(x -> x != null).anyMatch(this::isAncestorOf);
    }

    @Override
    default public DefaultContext<T> getCurrentCache() {
        return (DefaultContext)this.getRoot().getCurrentCache();
    }

    @Override
    default public Snapshot<T> getInstances() {
        return this.getCurrentCache().getInstances((DefaultVertex)this);
    }

    @Override
    default public Snapshot<T> getInheritings() {
        return this.getCurrentCache().getInheritings((DefaultVertex)this);
    }

    @Override
    default public Snapshot<T> getComposites() {
        return this.getCurrentCache().getComposites((DefaultVertex)this);
    }

    @Override
    default public Snapshot<T> getAllInheritings() {
        return () -> Stream.concat(Stream.of((DefaultVertex)this), this.getInheritings().get().flatMap(inheriting -> inheriting.getAllInheritings().get())).distinct();
    }

    @Override
    default public Snapshot<T> getAllInstances() {
        return () -> this.getAllInheritings().get().flatMap(inheriting -> inheriting.getInstances().get());
    }

    @Override
    default public T getInstance(T superT, Serializable value, T ... components) {
        return (T)((DefaultVertex)this.getInstance(Collections.singletonList(superT), value, (IVertex[])components));
    }

    @Override
    default public T getInstance(Serializable value, T ... components) {
        return (T)((DefaultVertex)this.getInstance(Collections.emptyList(), value, (IVertex[])components));
    }

    public static <T extends DefaultVertex<T>> Predicate<T> valueFilter(Serializable value) {
        return attribute -> Objects.equals(attribute.getValue(), value);
    }

    default public Predicate<T> componentsFilter(T ... components) {
        return attribute -> {
            int subIndex = 0;
            block0: for (DefaultVertex component : components) {
                while (subIndex < attribute.getComponents().size()) {
                    DefaultVertex subTarget = (DefaultVertex)attribute.getComponents().get(subIndex);
                    if (subTarget.isSpecializationOf(component)) {
                        if (this.isSingularConstraintEnabled(subIndex)) {
                            return true;
                        }
                        ++subIndex;
                        continue block0;
                    }
                    ++subIndex;
                }
                return false;
            }
            return true;
        };
    }

    @Override
    default public T getAttribute(Serializable value, T ... components) {
        return (T)((DefaultVertex)this.getAttributes().get().filter(DefaultDependencies.valueFilter(value)).filter(this.componentsFilter((DefaultVertex[])components)).findFirst().orElse(null));
    }

    @Override
    default public T getHolder(T attribute, Serializable value, T ... components) {
        return (T)((DefaultVertex)this.getHolders(attribute).get().filter(DefaultDependencies.valueFilter(value)).filter(this.componentsFilter((DefaultVertex[])components)).findFirst().orElse(null));
    }

    @Override
    default public T getRelation(Serializable value, T ... components) {
        return (T)((DefaultVertex)this.getRelations().get().filter(DefaultDependencies.valueFilter(value)).filter(this.componentsFilter((DefaultVertex[])components)).findFirst().orElse(null));
    }

    @Override
    default public T getLink(T relation, Serializable value, T ... components) {
        return (T)((DefaultVertex)this.getLinks(relation).get().filter(DefaultDependencies.valueFilter(value)).filter(this.componentsFilter((DefaultVertex[])components)).findFirst().orElse(null));
    }
}

