/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.defaults;

import org.genericsystem.api.core.IVertex;
import org.genericsystem.api.defaults.DefaultRoot;
import org.genericsystem.api.defaults.DefaultVertex;

public interface DefaultAncestors<T extends DefaultVertex<T>>
extends IVertex<T> {
    @Override
    default public boolean isRoot() {
        return this.equals(this.getRoot());
    }

    @Override
    default public int getLevel() {
        return this == this.getMeta() ? 0 : ((DefaultVertex)this.getMeta()).getLevel() + 1;
    }

    @Override
    default public DefaultRoot<T> getRoot() {
        return !this.isMeta() ? ((DefaultVertex)this.getMeta()).getRoot() : (this.getSupers().isEmpty() ? (DefaultRoot)((Object)this) : ((DefaultVertex)this.getSupers().get(0)).getRoot());
    }

    @Override
    default public boolean isMeta() {
        return this.getLevel() == 0;
    }

    @Override
    default public boolean isStructural() {
        return this.getLevel() == 1;
    }

    @Override
    default public boolean isConcrete() {
        return this.getLevel() == 2;
    }

    @Override
    default public boolean inheritsFrom(T superVertex) {
        if (this.equals(superVertex)) {
            return true;
        }
        if (this.getLevel() != superVertex.getLevel()) {
            return false;
        }
        for (DefaultVertex superT : this.getSupers()) {
            if (!superT.inheritsFrom(superVertex)) continue;
            return true;
        }
        return false;
    }

    @Override
    default public boolean isInstanceOf(T metaVertex) {
        return ((DefaultVertex)this.getMeta()).inheritsFrom(metaVertex);
    }

    @Override
    default public boolean isSpecializationOf(T supra) {
        return this.getLevel() == supra.getLevel() ? this.inheritsFrom(supra) : this.getLevel() > supra.getLevel() && ((DefaultVertex)this.getMeta()).isSpecializationOf(supra);
    }

    @Override
    default public boolean isCompositeOf(T vertex) {
        return this.isRoot() || this.getComponents().stream().anyMatch(component -> vertex.isSpecializationOf((Object)component));
    }

    @Override
    default public T getComponent(int pos) {
        return (T)(pos >= 0 && pos < this.getComponents().size() ? (DefaultVertex)this.getComponents().get(pos) : null);
    }

    @Override
    default public T getBaseComponent() {
        return (T)this.getComponent(0);
    }

    @Override
    default public T getTargetComponent() {
        return (T)this.getComponent(1);
    }

    @Override
    default public T getTernaryComponent() {
        return (T)this.getComponent(2);
    }
}

