/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@FunctionalInterface
public interface Snapshot<T>
extends Iterable<T> {
    @Override
    default public Iterator<T> iterator() {
        return this.get().iterator();
    }

    public Stream<T> get();

    default public int size() {
        return (int)this.get().count();
    }

    default public boolean isEmpty() {
        return this.get().count() == 0L;
    }

    default public boolean contains(Object o) {
        return o.equals(this.get(o));
    }

    default public boolean containsAll(Collection<?> c) {
        return c.stream().allMatch(x -> this.get().anyMatch(y -> y.equals(x)));
    }

    default public T get(Object o) {
        return this.get().filter(o::equals).findFirst().orElse(null);
    }

    default public String info() {
        return this.get().collect(Collectors.toList()).toString();
    }

    default public T first() {
        return this.get().findFirst().orElse(null);
    }
}

