/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Snapshot<T>
extends Iterable<T> {
    default public int size() {
        Iterator iterator = this.iterator();
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    default public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    default public boolean contains(Object o) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            if (!o.equals(it.next())) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    default public T get(T o) {
        for (Object next : this) {
            if (!o.equals(next)) continue;
            return next;
        }
        return null;
    }

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public String info() {
        return this.stream().collect(Collectors.toList()).toString();
    }

    public static abstract class AbstractSnapshot<T>
    implements Snapshot<T> {
        public static <T> Snapshot<T> emptySnapshot() {
            return new AbstractSnapshot<T>(){

                @Override
                public Iterator<T> iterator() {
                    return Collections.emptyIterator();
                }
            };
        }

        public String toString() {
            Iterator it = this.iterator();
            if (!it.hasNext()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            while (true) {
                Object e;
                sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
                if (!it.hasNext()) {
                    return sb.append(']').toString();
                }
                sb.append(',').append(' ');
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Snapshot)) {
                return false;
            }
            Snapshot s = (Snapshot)o;
            Iterator e1 = this.iterator();
            Iterator e2 = s.iterator();
            while (e1.hasNext() && e2.hasNext()) {
                Object o2;
                Object o1 = e1.next();
                if (Objects.equals(o1, o2 = e2.next())) continue;
                return false;
            }
            return !e1.hasNext() && !e2.hasNext();
        }

        public int hashCode() {
            int hashCode = 1;
            for (Object e : this) {
                hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
            }
            return hashCode;
        }
    }
}

