/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.api.tree;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.genericsystem.api.core.Generic;
import org.genericsystem.api.model.Holder;
import org.genericsystem.api.model.Snapshot;

public interface Node
extends Holder {
    public <T extends Node> T addNode(Serializable var1, Generic ... var2);

    public <T extends Node> T getChild(Serializable var1);

    public <T extends Node> Snapshot<T> getChildren();

    public <T extends Node> Snapshot<T> getChildren(int var1);

    public <T extends Node> T setNode(Serializable var1, Generic ... var2);

    public <T extends Node> T setSubNode(Serializable var1, Generic ... var2);

    public void traverse(Visitor var1);

    public static abstract class Visitor {
        protected Set<Node> alreadyVisited = new HashSet<Node>();

        public void after(Node node) {
        }

        public void before(Node node) {
        }

        public void traverse(Node node) {
            if (this.alreadyVisited.add(node)) {
                this.before(node);
                for (Node child : node.getChildren()) {
                    this.traverse(child);
                }
                this.after(node);
            }
        }
    }
}

